    #!/usr/bin/python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import sys, os, time
from datetime import datetime, timedelta
from codecs import open
from common import *

class MaskedFile:
    def __init__(self, file_name, N = 0):
        self._file_name = file_name
        self.N = N
        self._dt = datetime.today() - timedelta(days = N)
        self._f = open(file_name + (".%d" if N else ""), "rt", FRODOLOG_CHARSET, "ignore")
        self._buf = ""
        self.pos = 0

    def switch(self, onlystatus = False):
        N = (datetime.today() - self._dt).days
        if self.N < N:
            newname = self._file_name + (".%d" if self.N else "")
        if os.path.exists(self._file_name):
            if not onlystatus:
                try:
                    statinfo = os.stat(self._file_name)
                    loggerFLP.trace("File: %s, Position: %s, FileLength: %s, Closed: %s" % (self._file_name, self.pos, statinfo[6], self._f.closed))
                    if int(statinfo[6]) <= self.pos and not self._f.closed:
                        self._f.close()
                        if int(statinfo[6]) < self.pos:
                            self.pos = 0
                    self._f = open(self._file_name, "rt", FRODOLOG_CHARSET, "ignore")
                    self._f.seek(self.pos)
                except Exception, e:
                    loggerFLP.error("File switch exception: %s" % str(e), True)
            return True
        else:
            return False

    def readLine(self):
        line = self._f.readline()
        self._buf += line
        if not (len(line) == 0 and self.canSwitch()) and (len(self._buf) == 0 or self._buf[-1] != "\n"):
            return ""
        else:
            ret = self._buf
            self._buf = ""
            return ret

    def bufEmpty(self):
        return len(self._buf) == 0

    def canSwitch(self):
        return self.switch(True)

    def getFile(self):
        return self._f

class LogReader:
    def __init__(self, db, follow):
        self._files = []
        self._parsers = {}
        self._db = db
        self._follow = follow

    def addLog(self, maskedfile):
        self._files.append(maskedfile)
        return len(self._files) - 1

    def addParser(self, logid, parser):
        if logid not in self._parsers:
            self._parsers[logid] = [parser]
        else:
            self._parsers[logid].append(parser)

    def process(self):
        i, errors, last, l = 0, 0, time.time(), len(self._files)
        if l == 0:
            loggerFLP.trace("Parsing finished")
            return
        self.getPosition()
        while True:
            dt = datetime.today().date()
            if errors == l:
                cs_count = 0
                for i in range(l):
                    if (not self._follow or self._files[i].canSwitch()) and self._files[i].bufEmpty():
                        cs_count += 1
                if cs_count == l:
                    loggerFLP.trace("Processing of files finished?")
                    self.writePosition()
                    if not self._follow:
                        break
                    for i in range(l):
                        self._files[i].switch()
                        for parser in self._parsers[i]:
                            parser.logSwitch(self._files[i].getFile().name)
                    self._db.logSwitch(dt)
                    self.writePosition()
                time.sleep(1)
            if time.time() - last > UPDATE_PERIOD or len(self._db.logins.keys()) > MAX_LOGINS_COUNT:
            #if time.time() - last > UPDATE_PERIOD:
               self._db.save(dt)
               self.writePosition()
               last = time.time()
            errors = 0
            for i in range(l):
                if i not in self._parsers:
                    continue
                f = self._files[i].getFile()
                line = self._files[i].readLine()
                if len(line) == 0:
                    errors += 1
                    if i == 0:
                        loggerFLP.trace("Parsing of file %s finished" % f.name)
                else:
                    prev_line = line
                    for parser in self._parsers[i]:
                        try:
                            parser.parse(line, f.name)
                        except Exception, e:
                            loggerFLP.error("Parsing line '%s' in file '%s' failed: %s" % (line, f.name, str(e)), True)
        loggerFLP.trace("Parsing finished")
        for file_parsers in self._parsers.values():
            for parser in file_parsers:
                parser.logSwitch(dt)
        self._db.logSwitch(dt)
        self.writePosition()

    def getPosition(self):
        try:
            statinfo = os.stat(FRODO_LOGPARSE_POS)
            if len(statinfo) >= 9 and datetime.fromtimestamp(statinfo[8]).date() < datetime.today().date():
                return
            f = open(FRODO_LOGPARSE_POS)
            l = len(self._files)
            for i in range(l):
                self._files[i].pos = int(f.readline().strip())
                loggerFLP.trace("File %s: seek to position %s" % (self._files[i].getFile().name, self._files[i].pos))
                self._files[i].getFile().seek(self._files[i].pos)
        except:
            pass

    def writePosition(self):
        f = open(FRODO_LOGPARSE_POS, 'wt')
        l = len(self._files)
        for i in range(l):
            self._files[i].pos = self._files[i].getFile().tell()
            loggerFLP.trace("File %s: current position %s" % (self._files[i].getFile().name, self._files[i].pos))
            print >>f, "%d" % self._files[i].pos
        f.close()
