#!/usr/bin/python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import re, time
from datetime import datetime
from common import loggerFLP

class SendAnswerParser:
    def __init__(self, db, period):
        self._re_time = re.compile(r"\[([^\]\[]*)\]")
        self._re_user = re.compile(r"<[^\s]+\s+login=\"([^\"]*)\"\ weight=\"([^\"]*)\"\ />(\*?)")
        self._db = db
        self._period = period

    def logSwitch(self, filename):
        pass

    def parse(self, line, filename):
        time_str = self._re_time.findall(line)
        if len(time_str) == 0:
            return
        dt = datetime.strptime(time_str[0], "%Y.%m.%d %H:%M:%S")
        now = int(time.mktime(dt.date().timetuple()))
        timestamp = time.mktime(dt.timetuple())
        timeperiod = int(timestamp / self._period) * self._period
        c = self._db.graph[timeperiod]
        for (name, weight, star) in self._re_user.findall(line):
            l = self._db.logins[name]
            if l.firstreg == -1:
                l.firstreg = timestamp
            else:
                l.firstreg = min(l.firstreg, timestamp)
            l.lastreg = timestamp
            if not star:
                if weight == "85":
                    c.spam += 1
                    l.spam[now] += 1
                elif weight == "100":
                    c.malic += 1
                    l.malic[now] += 1
                else:
                    loggerFLP.error("undefined weight %s in %s" % (weight, filename))
