#!/usr/bin/python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from datetime import datetime

class CsvGraphOutput:
    def __init__(self):
        self._fields = []
        self._result = ""

    def addFieldExtractor(self, lambda_f):
        self._fields.append(lambda_f)

    def addResult(self, s):
        self._result += s

    def parse(self, timestamp, obj):
        dt = datetime.fromtimestamp(int(timestamp)).strftime("%d-%m-%Y %H:%M:%S")
        self.addResult(dt + ";")
        for f in self._fields:
            if f != self._fields[0]:
                self.addResult(";")
            try:
                self.addResult(str(f(obj)))
            except:
                self.addResult("0")
        self.addResult("\n")

    def getResult(self):
        return self._result
