#!/usr/bin/python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import wsgiref, time, os, sys, cgi, json, binascii
from urllib import urlopen
from flup.server.fcgi import WSGIServer
from datetime import datetime
from collections import defaultdict

sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '../parser/')))
from xmlgraphoutput import XmlGraphOutput
from dbextractor import DataExtractor
from common import *
from daemonize import *

FASTCGI_PORT = 8855
PIDFILE = "/var/run/frodo_stat.pid"
RETRY_COUNT = 3

def timestamp(s):
    return int(time.mktime(datetime.strptime(s, "%d-%m-%Y %H:%M:%S").timetuple()))

def todayMidnight():
    return timestamp(datetime.today().strftime("%d-%m-%Y 00:00:00"))

def now():
    return timestamp(datetime.today().strftime("%d-%m-%Y %H:%M:%S"))

def doRequest(url, prompt = "doRequest"):
    try:
        f = urlopen(url)
        if f.getcode() == 200:
            return f.read()
        else:
            loggerFS.error('{0} response HTTP code: {1}, body: {2}'.format(prompt, f.getcode(), f.info()))
    except Exception, e:
        loggerFS.error('%s HTTP request failed: %s.\n' % (prompt, str(e)), True)
    return ""

def getNannyInstances(service, default_hosts = []):
    try:
        for i in range(RETRY_COUNT):
            r = doRequest("https://nanny.yandex-team.ru/v2/services/%s/current_state/instances/" % service, "Get instances for Nanny service '%s'" % service)
            if r:
                info = json.loads(r.strip())
                return map(lambda item: item['container_hostname'], info['result'])
            else: continue
    except Exception, e:
        loggerFS.error("getNannyInstances exception: %s" % str(e), True)
    return default_hosts

def parameters(form):
    if "starttime" in form:
        starttime = timestamp(form["starttime"][0].strip())
    else:
        starttime = todayMidnight()
    if "endtime" in form:
        endtime = timestamp(form["endtime"][0].strip())
    else:
        endtime = now()
    follow = "follow" in form
    return starttime, endtime, follow

def queryGraphShm(form):
    starttime, endtime, follow = parameters(form)
    graph = XmlGraphOutput()
    graph.addFieldExtractor(lambda obj: obj["spam"])
    graph.addFieldExtractor(lambda obj: obj["total"] - obj["spam"] - obj["malic"])
    graph.addFieldExtractor(lambda obj: obj["malic"])
    db = DataExtractor()
    db.parsePeriod(starttime, endtime, follow, graph, ["total", "spam", "malic"])
    return graph.getResult()

def queryGraphTurkeyShm(form):
    starttime, endtime, follow = parameters(form)
    graph = XmlGraphOutput()
    graph.addFieldExtractor(lambda obj: obj["spam_turkey"])
    graph.addFieldExtractor(lambda obj: obj["total_turkey"] - obj["spam_turkey"] - obj["malic_turkey"])
    graph.addFieldExtractor(lambda obj: obj["malic_turkey"])
    db = DataExtractor()
    db.parsePeriod(starttime, endtime, follow, graph, ["total_turkey", "spam_turkey", "malic_turkey"])
    return graph.getResult()

def queryGraphRegTypes(form):
    starttime, endtime, follow = parameters(form)
    graph = XmlGraphOutput()
    regtypes = ['ADMREG', 'COMPLEATE_PDD', 'ALTERNATIVEHINT', 'ALTERNATIVEPHONE', 'ADMSOCIALREG', 'REQTYPE_COMPLETE', 'SIMPLE']
    #for regtype in regtypes:
    #    graph.addFieldExtractor(lambda obj: obj[regtype], lambda s: s[regtype], regtype)
    graph.addFieldExtractor(lambda obj: obj['ADMREG'], lambda s: s['ADMREG'], 'ADMREG')
    graph.addFieldExtractor(lambda obj: obj['COMPLEATE_PDD'], lambda s: s['COMPLEATE_PDD'], 'COMPLEATE_PDD')
    graph.addFieldExtractor(lambda obj: obj['ALTERNATIVEHINT'], lambda s: s['ALTERNATIVEHINT'], 'ALTERNATIVEHINT')
    graph.addFieldExtractor(lambda obj: obj['ALTERNATIVEPHONE'], lambda s: s['ALTERNATIVEPHONE'], 'ALTERNATIVEPHONE')
    graph.addFieldExtractor(lambda obj: obj['ADMSOCIALREG'], lambda s: s['ADMSOCIALREG'], 'ADMSOCIALREG')
    graph.addFieldExtractor(lambda obj: obj['REQTYPE_COMPLETE'], lambda s: s['REQTYPE_COMPLETE'], 'REQTYPE_COMPLETE')
    graph.addFieldExtractor(lambda obj: obj['SIMPLE'], lambda s: s['SIMPLE'], 'SIMPLE')
    db = DataExtractor()
    db.parsePeriod(starttime, endtime, follow, graph, regtypes, 'regtype')
    return graph.getResult()

def queryGraphChPass(form):
    starttime, endtime, follow = parameters(form)
    graph = XmlGraphOutput()
    graph.addFieldExtractor(lambda obj: obj["CHANGE_PASSWORD"], lambda s: s["CHANGE_PASSWORD"], "CHANGE_PASSWORD" )
    graph.addFieldExtractor(lambda obj: obj["VOLUNTARILY"], lambda s: s["VOLUNTARILY"], "VOLUNTARILY" )
    graph.addFieldExtractor(lambda obj: obj["FORCE"], lambda s: s["FORCE"], "FORCE" )
    graph.addFieldExtractor(lambda obj: obj["STRONG"], lambda s: s["STRONG"], "STRONG" )
    db = DataExtractor()
    db.parsePeriod(starttime, endtime, follow, graph, ['CHANGE_PASSWORD', 'VOLUNTARILY', 'FORCE', 'STRONG'], 'chpass_type')
    return graph.getResult()

def queryGraphServices(form):
    starttime, endtime, follow = parameters(form)
    graph = XmlGraphOutput()
    graph.addFieldExtractor(lambda obj: obj["dash"], lambda s: s['dash'], "-")
    graph.addFieldExtractor(lambda obj: obj["mail"], lambda s: s["mail"], "mail")
    graph.addFieldExtractor(lambda obj: obj["passport"], lambda s: s["passport"], "passport")
    graph.addFieldExtractor(lambda obj: obj["music"], lambda s: s["music"], "music")
    graph.addFieldExtractor(lambda obj: obj["market"], lambda s: s["market"], "market")
    graph.addFieldExtractor(lambda obj: obj["pdd"], lambda s: s["pdd"], "pdd")
    graph.addFieldExtractor(lambda obj: obj["cloud"], lambda s: s["cloud"], "cloud")
    graph.addFieldExtractor(lambda obj: obj["webmaster"], lambda s: s["webmaster"], "webmaster")
    db = DataExtractor()
    db.parsePeriod(starttime, endtime, follow, graph, ['dash', 'mail', 'passport', 'music', 'market', 'pdd', 'cloud', 'webmaster'], 'service')
    return graph.getResult()

def queryGraphIps(form):
    starttime, endtime, follow = parameters(form)
    graph = XmlGraphOutput()
    graph.addFieldExtractor( lambda obj: obj["ips"])
    graph.addFieldExtractor( lambda obj: obj["newips"])
    db = DataExtractor()
    db.parsePeriod(starttime, endtime, follow, graph, ["ips", "newips"])
    return graph.getResult()

def queryGraphEmailPhones(form):
    starttime, endtime, follow = parameters(form)
    graph = XmlGraphOutput()
    graph.addFieldExtractor(lambda obj: obj["emails"])
    graph.addFieldExtractor(lambda obj: obj["phones"])
    db = DataExtractor()
    db.parsePeriod(starttime, endtime, follow, graph, ["emails", "phones"])
    return graph.getResult()

def queryGraphBadGeo(form):
    starttime, endtime, follow = parameters(form)
    graph = XmlGraphOutput()
    graph.addFieldExtractor(lambda obj: obj["badgeo"])
    graph.addFieldExtractor(lambda obj: obj["whitelist"])
    db = DataExtractor()
    db.parsePeriod(starttime, endtime, follow, graph, ["badgeo", "whitelist"])
    return graph.getResult()

def queryGraphGoodIps(form):
    starttime, endtime, follow = parameters(form)
    graph = XmlGraphOutput()
    graph.addFieldExtractor(lambda obj: obj["spam_from_good50"])
    graph.addFieldExtractor(lambda obj: obj["spam_from_good75"])
    db = DataExtractor()
    db.parsePeriod(starttime, endtime, follow, graph, ["spam_from_good50", "spam_from_good75"])
    return graph.getResult()

def queryIpStatistics(form):
    filter = json.loads(form["filter"][0].strip())
    db = DataExtractor()
    return json.dumps(db.extractIpInfo(form["field"][0], int(form["number"][0]), filter))

def queryGeoZones():
    db = DataExtractor()
    return json.dumps(db.getGeoZones())

def queryGeoGroups():
    db = DataExtractor()
    return json.dumps(db.getGeoGroups())

def querySaveGeoGroup( form ):
    db = DataExtractor()
    name = form[ "name" ][ 0 ].strip()
    value = form[ "value" ][ 0 ].strip()
    return db.saveGeoGroup( name, value )

def queryDeleteGeoGroup( form ):
    db = DataExtractor()
    name = form[ "name" ][ 0 ].strip()
    return db.deleteGeoGroup( name )

def queryGeoStat( form ):
    db = DataExtractor()
    return json.dumps( db.getGeoStat() )

def queryGeoStatWhite( form ):
    db = DataExtractor()
    return json.dumps( db.getGeoStatWhite() )

def queryGeoStatAddWhite( form ):
    db = DataExtractor()
    name = form[ "name" ][ 0 ].strip()
    return db.addGeoStatWhite( name )

def queryGeoStatRemoveWhite( form ):
    db = DataExtractor()
    name = form[ "name" ][ 0 ].strip()
    return db.removeGeoStatWhite( name )

def querySignalShortLog( form ):
    db = DataExtractor()
    timestamp = form[ "timestamp" ][ 0 ].strip()
    keyword = form[ "keyword" ][ 0 ].strip()
    return db.getSignalShortLog( timestamp, keyword )

def querySignalList( form ):
    db = DataExtractor()
    date = datetime.strptime( form[ "date" ][ 0 ].strip(), "%d-%m-%Y" )
    return json.dumps( db.getSignalList( date ) )

def crc_unsigned(data):
    return binascii.crc32(data) & 0xFFFFFFFF

MACHINES = getNannyInstances('so_frodooborona', ["sas1-3015-sas-so-frodooborona--1d3-17921.gencfg-c.yandex.net","iva1-0503-a25-msk-iva-so-frodo-e4e-18274.gencfg-c.yandex.net","vla1-2066-vla-so-frodooborona--e76-20088.gencfg-c.yandex.net"])
LOCLS = defaultdict(int)
getCredentials()
for i, name in enumerate(MACHINES):
    LOCLS[str(crc_unsigned(name))] = i + 1

def queryGraphLocl(form):
    global LOCLS
    starttime, endtime, follow = parameters(form)
    graph = XmlGraphOutput()
    graph.addFieldExtractor(lambda obj: LOCLS[str(obj["locl"])])
    db = DataExtractor()
    db.parsePeriod(starttime, endtime, follow, graph, ["locl"])
    return graph.getResult()

def FcgiHandler(environ, start_response):
    form = cgi.parse_qs(environ['QUERY_STRING'])
    query = form["query"][0].strip()

    if query == "graph_shm":
        start_response( "200 OK", [ ( "Content-Disposition", "attachment;filename=data.xml" ) ] )
        data = queryGraphShm( form )
        loggerFS.trace("Form: %s, Data: %s" % (form, json.dumps(data)))
        return [ data ]
    elif query == "graph_regtypes":
        start_response( "200 OK", [ ( "Content-Disposition", "attachment;filename=data.xml" ) ] )
        return [ queryGraphRegTypes( form ) ]
    elif query == "graph_chpass":
        start_response( "200 OK", [ ( "Content-Disposition", "attachment;filename=data.xml" ) ] )
        return [ queryGraphChPass( form ) ]
    elif query == "graph_services":
        start_response( "200 OK", [ ( "Content-Disposition", "attachment;filename=data.xml" ) ] )
        return [ queryGraphServices( form ) ]
    elif query == "graph_ips":
        start_response( "200 OK", [ ( "Content-Disposition", "attachment;filename=data.xml" ) ] )
        return [ queryGraphIps( form ) ]
    elif query == "graph_emailphones":
        start_response( "200 OK", [ ( "Content-Disposition", "attachment;filename=data.xml" ) ] )
        return [ queryGraphEmailPhones( form ) ]
    elif query == "graph_badgeo":
        start_response( "200 OK", [ ( "Content-Disposition", "attachment;filename=data.xml" ) ] )
        return [ queryGraphBadGeo( form ) ]
    elif query == "graph_goodip":
        start_response( "200 OK", [ ( "Content-Disposition", "attachment;filename=data.xml" ) ] )
        return [ queryGraphGoodIps( form ) ]
    elif query == "period":
        start_response( "200 OK", [ ( "Content-type", "text/html" ) ] )
        return [ str( PARSE_PERIOD ) ]
    elif query == "ips":
        start_response( "200 OK", [ ( "Content-type", "text/html" ) ] )
        return [ queryIpStatistics( form ) ]
    elif query == "geozones":
        start_response( "200 OK", [ ( "Content-type", "text/html" ) ] )
        return [ queryGeoZones() ]
    elif query == "geogroups":
        start_response( "200 OK", [ ( "Content-type", "text/html" ) ] )
        return [ queryGeoGroups() ]
    elif query == "savegeogroup":
        start_response( "200 OK", [ ( "Content-type", "text/html" ) ] )
        return [ querySaveGeoGroup( form ) ]
    elif query == "deletegeogroup":
        start_response( "200 OK", [ ( "Content-type", "text/html" ) ] )
        return [ queryDeleteGeoGroup( form ) ]
    elif query == "geostat":
        start_response( "200 OK", [ ( "Content-type", "text/html" ) ] )
        return [ queryGeoStat( form ) ]
    elif query == "geostatwhite":
        start_response( "200 OK", [ ( "Content-type", "text/html" ) ] )
        return [ queryGeoStatWhite( form ) ]
    elif query == "geostataddwhite":
        start_response( "200 OK", [ ( "Content-type", "text/html" ) ] )
        return [ queryGeoStatAddWhite( form ) ]
    elif query == "geostatremovewhite":
        start_response( "200 OK", [ ( "Content-type", "text/html" ) ] )
        return [ queryGeoStatRemoveWhite( form ) ]
    elif query == "signal_shortlog":
        start_response( "200 OK", [ ( "Content-type", "text/plain" ) ] )
        return [ querySignalShortLog( form ) ]
    elif query == "signalslist":
        start_response( "200 OK", [ ( "Content-type", "text/plain" ) ] )
        return [ querySignalList( form ) ]
    elif query == "graph_kpi_monthlogins":
        start_response( "200 OK", [ ( "Content-Disposition", "attachment;filename=data.xml" ) ] )
        return [ queryKpiMonthLogins( form ) ]
    elif query == "graph_shm_turkey":
        start_response( "200 OK", [ ( "Content-Disposition", "attachment;filename=data.xml" ) ] )
        return [ queryGraphTurkeyShm( form ) ]
    elif query == "graph_shm_galatasaray":
        start_response( "200 OK", [ ( "Content-Disposition", "attachment;filename=data.xml" ) ] )
        return [ queryGraphGalatasarayShm( form ) ]
    elif query == "graph_locl":
        start_response( "200 OK", [ ( "Content-Disposition", "attachment;filename=data.xml" ) ] )
        return [ queryGraphLocl( form ) ]
    else:
        start_response( "200 OK", [ ( "Content-type", "text/html" ) ] )
        return [ "Unknown command: <b>%s</b>" % query ]

loggerFS.trace("Starting frodo_stat fastcgi-daemon")
try:
    become_daemon()
    writePid(PIDFILE)
    WSGIServer(FcgiHandler, bindAddress = ('', FASTCGI_PORT)).run()
except Exception, e:
    loggerFS.error("frodo_stat error: %s" % e, True)
