#!/usr/bin/python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from datetime import datetime
from common import loggerFS

class XmlGraphOutput:
    def __init__(self):
        self._times = []
        self._graphs = []
        self._fields = []

    def addFieldExtractor(self, lambda_f, lambda_s = lambda obj: "", logkeyword = ""):
        self._fields.append([lambda_f, lambda_s, logkeyword])
        self._graphs.append([])

    def parse(self, timestamp, obj, signals):
        dt = datetime.fromtimestamp(int(timestamp))
        self._times.append(dt)
        for index, (f, s, keyword) in enumerate(self._fields):
            try:
                self._graphs[index].append([str(f(obj)), s(signals), keyword])
            except Exception, e:
                self._graphs[index].append(["0", s(signals), keyword])
                loggerFS.error("XmlGraphOutput parse exception: %s" % str(e))

    def getResult(self, dateformat = "%d-%m-%Y %H:%M:%S"):
        ret = "<chart>\n"
        ret += "\t<series>\n"
        for index, dt in enumerate(self._times):
            ret += "\t\t<value xid=\"%d\">%s</value>\n" % (index, dt.strftime(dateformat))
        ret += "\t</series>\n"
        ret += "\t<graphs>\n"
        for index, graph in enumerate(self._graphs):
            ret += "\t\t<graph gid=\"%d\">\n" % (index + 1)
            for index, (value, signal, keyword) in enumerate(graph):
                if len(signal) > 0:
                    timestamp = datetime.fromtimestamp(signal[0]).strftime("%Y-%m-%d %H:%M:%S")
                    ret += "\t\t\t<value xid=\"%d\" url=\"javascript:showSignalLog('%s', '%s')\" description=\"%s\" bullet=\"round\">%s</value>\n" % \
                            (index, timestamp, keyword, signal[1], value)
                else:
                    ret += "\t\t\t<value xid=\"%d\">%s</value>\n" % (index, value)
            ret += "\t\t</graph>\n"
        ret += "\t</graphs>\n"
        ret += "</chart>\n"
        return ret
