#!/usr/bin/env python2.7
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, pymongo
from common import writelog, getHosts4Group

def mongo_conn_str(cfg):
    s, hosts = '', cfg.get('hosts', '127.0.0.1').split(',')
    if 'user' in cfg and cfg['user']:
        s = "%s:%s@" % (cfg['user'], cfg['passwd'])
    return "mongodb://%s%s/%s" % (s, ','.join(getHosts4Group(cfg.get('cluster', ''), hosts)), cfg['db'])

def loadMongoDbCredentials(cfg):
    f, CURDIR = None, 'WORKING_DIR'
    try:
        if not os.path.exists('%s/.mongodb.%s' % (CURDIR, cfg['db'])):
            CURDIR = os.path.dirname(os.path.abspath(__file__))
            if not os.path.exists('%s/.mongodb.%s' % (CURDIR, cfg['db'])):
                CURDIR = os.environ['HOME'] if 'HOME' in os.environ else '/root'
        if os.path.exists('%s/.mongodb.%s' % (CURDIR, cfg['db'])):
            f = open('%s/.mongodb.%s' % (CURDIR, cfg['db']))
            for line in f:
                sf = line.split(':')
                if len(sf) == 2:
                    cfg['user'], cfg['passwd'] = sf[0], sf[1].strip()
                    break
            f.close()
        elif 'user' in cfg:
            writelog("ERROR: Unable to locate file with DB credentials!")
    except Exception, e:
        writelog("loadMongoDbCredentials exception: %s" % str(e), True)

def getMongoDB(cfg, params={}):
    if not hasattr(getMongoDB, "%s_connection" % cfg['db']):
        timeout = cfg['timeout'] if 'timeout' in cfg and cfg['timeout'] else 10000
        if "connectTimeoutMS" not in params:
            params["connectTimeoutMS"] = timeout
        if "socketTimeoutMS" not in params:
            params["socketTimeoutMS"] = timeout
        setattr(getMongoDB, "%s_connection" % cfg['db'], pymongo.MongoClient(host=mongo_conn_str(cfg), port=cfg.get('port', 27017), **params)[cfg['db']])
    return getattr(getMongoDB, "%s_connection" % cfg['db'])
