#!/usr/bin/env python2.7
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, psycopg2
from common import writelog


def getPGCredentials(cfg):
    f, CURDIR, dbname = None, 'WORKING_DIR', cfg['db'][:len(cfg['db']) - 2] if cfg['db'].endswith('db') else cfg['db']
    try:
        if not os.path.exists('{0}/.pgpass.{1}'.format(CURDIR, dbname)):
            CURDIR = os.path.dirname(os.path.abspath(__file__))
            if not os.path.exists('{0}/.pgpass.{1}'.format(CURDIR, dbname)) and 'HOME' in os.environ:
                CURDIR = os.environ['HOME']
        f = open('{0}/.pgpass.{1}'.format(CURDIR, dbname))
        for line in f:
            sf = line.split(':')
            if len(sf) == 5 and sf[2] == cfg['db']:
                cfg['host'], cfg['port'], cfg['user'], cfg['password'] = sf[0], int(sf[1]), sf[3], sf[4].strip()
                break
        f.close()
    except Exception, e:
        writelog("getPGCredentials exception: %s" % str(e), True)

def getPGdb(cfg, mode = 'read-write'):
    if not hasattr(getPGdb, "%s_connection" % cfg['db']) or hasattr(getattr(getPGdb, "%s_connection" % cfg['db']), 'closed') and getattr(getattr(getPGdb, "%s_connection" % cfg['db']), 'closed'):
        CURDIR = 'WORKING_DIR'
        if not os.path.exists('%s/.pgsql/root.crt' % CURDIR):
            CURDIR = os.path.dirname(os.path.abspath(__file__))
            if not os.path.exists('%s/.pgsql/root.crt' % CURDIR) and 'HOME' in os.environ:
                CURDIR = os.environ['HOME']
        if hasattr(psycopg2, '__libpq_version__'):
            setattr(getPGdb, "%s_connection" % cfg['db'], psycopg2.connect(dbname=cfg['db'], user=cfg['user'], password=cfg['password'], host=cfg['host'], port=cfg['port'], sslmode='verify-full', sslrootcert='%s/.pgsql/root.crt' % CURDIR, target_session_attrs=('read-write' if mode == 'read-write' else 'any')))
        else:
            if ',' in cfg['host']:
                for host in cfg['host'].split(','):
                    try:
                        pg = psycopg2.connect(database=cfg['db'], user = cfg['user'], password=cfg['password'], host=host, port=cfg['port'], sslmode='verify-full', sslrootcert='%s/.pgsql/root.crt' % CURDIR)
                        pg_cursor = pg.cursor()
                        pg_cursor.execute("SELECT pg_is_in_recovery()")
                        res = pg_cursor.fetchone()
                        pg_cursor.close()
                        if res and (mode == 'read-write' and not res[0] or mode != 'read-write' and res[0]):
                            return pg
                    except Exception, e:
                        writelog("getPGdb exception: %s" % str(e), True)
                        continue
            else:
                setattr(getPGdb, "%s_connection" % cfg['db'], psycopg2.connect(database = cfg['db'], user=cfg['user'], password=cfg['password'], host=cfg['host'], port=cfg['port'], sslmode='verify-full', sslrootcert='%s/.pgsql/root.crt' % CURDIR))
    return getattr(getPGdb, "%s_connection" % cfg['db'])
