#!/usr/bin/env python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, sys
sys.path.append("python-dateutil-2.4.2")
import dateutil
from tempfile import NamedTemporaryFile
from dateutil.relativedelta import relativedelta
from datetime import datetime, time, timedelta
from collections import defaultdict
from socket import gethostname

PREFIX = "so.newcompl"
TYPES = {"H": "antifoo", "S": "foo", "U": "unsubscribe"}
#COMPLLOG_FILEMASK = "/u0/" + gethostname() + "/usr/local/www/logs/compl.log-%Y-%m-%d"
COMPLLOG = "/u0/" + gethostname() + "/logs/compl.log"

def get_footype(foo, flags):
    if flags.find("_UN") >= 0:
        return TYPES["U"]
    return TYPES.get(foo, "-")

def is_corp(suid):
    return len(suid) == 16 and suid.startswith("112000")

print datetime.today().strftime("[%Y-%m-%d %H:%M:%S]"), "Started"

long_time_ago = datetime.fromtimestamp(0)
today = datetime.today().date()
dt = today - relativedelta(months=5)
dt -= timedelta(days=dt.day - 1)
start_check = dt + relativedelta(months=3)

suids = defaultdict(int)
stat_day = defaultdict(int)
errors = defaultdict(int)

while dt <= today:
    n = (today - dt).days
    COMPLLOG_FILE = COMPLLOG + (".{}".format(n) if n > 0 else "")
    print >> sys.stderr, "Parsing", COMPLLOG_FILE
    try:
        i = 0
        for line in open(COMPLLOG_FILE):
            try:
                parts = line.split("\t")
                foo, flags, suid = parts[2], parts[5], parts[7]
                if dt >= start_check:
                    footype = get_footype(foo, flags)
                    if (dt - suids.get(suid, long_time_ago)).days >= 90:
                        stat_day[(dt, footype, is_corp(suid))] += 1
                suids[suid] = dt
            except Exception, e:
                errors[str(e)] += 1
            i += 1
    except Exception, e:
        errors[str(e)] += 1
    print "Done. Total: %d Errors: %s" % (i, len(errors))
    dt += timedelta(days=1)

f = NamedTemporaryFile(delete = True)
for (dt, footype, corp), count in stat_day.iteritems():
    if corp:
        print >> f, "%s.corp.day.%s" % (PREFIX, footype), "set_%d" % count, int(dt.strftime("%s"))
    else:
        print >> f, "%s.day.%s" % (PREFIX, footype), "set_%d" % count, int(dt.strftime("%s"))
f.flush()

os.system("/opt/plotnik/plotnik_collector.py -f %s" % f.name)
print datetime.today().strftime("[%Y-%m-%d %H:%M:%S]"), "Done"
