#!/usr/bin/env python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from __future__ import print_function
import os, os.path, sys, re, json
sys.path.insert(0, 'WORKING_DIR')
from time import time
from collections import defaultdict
from datetime import date, timedelta, datetime
from socket import gethostname
from common import writelog, doRequest, TVM, loadTVMConfig, getUID, requestService

global CURDIR, COMPLLOG_FILE, ROBOT, DAY

CURDIR = 'WORKING_DIR'
#COMPLLOG_FILE = '/u0/%s/usr/local/www/logs/compl.log-%s'
COMPLLOG_FILE = '/u0/%s/logs/compl.log.%s'
ROBOT = {'user': 'robot-mailspam'}
DAY = sys.argv[1] if len(sys.argv) > 1 else date.today().isoformat()


def send_yastat(period, data):
    global CURDIR, ROBOT
    start = time()
    if not os.path.exists('%s/.yastat.%s' % (CURDIR, ROBOT['user'])):
        CURDIR = os.path.dirname(os.path.abspath(__file__))
        if not os.path.exists('%s/.yastat.%s' % (CURDIR, ROBOT['user'])) and 'HOME' in os.environ:
            CURDIR = os.environ['HOME']
    if os.path.exists('%s/.yastat.%s' % (CURDIR, ROBOT['user'])):
        f = open('%s/.yastat.%s' % (CURDIR, ROBOT['user']))
        ROBOT['token'] = f.read().strip()
        f.close()
    elif 'user' in ROBOT:
        writelog("ERROR: Unable to locate file with DB credentials!", False)
        return time() - start, 404
    if period == 'week':
        name, scale = 'So/Uniq_Complainants_By_Week', 'w'
    elif period == 'month':
        name, scale = 'So/Uniq_Complainants_By_Month', 'm'
    resp, code = requestService('https://upload.stat.yandex-team.ru/_api/report/data/%s' % name,
        headers={'Authorization': "OAuth {}".format(ROBOT['token'])},
        data={
            'name':  name,
            'scale': scale,
            'json_data':  json.dumps({'values': data}),
        })
    return time() - start, code


if __name__ == "__main__":
    try:
        d = datetime.strptime(DAY, '%Y-%m-%d').date() - timedelta(days=1)
    except:
        d = date.today() - timedelta(days=1)

    i, k, l, n, dw, dm, uids, t = 0, 0, 0, 0, d - timedelta(days=d.weekday()), d - timedelta(days=d.day-1), [], time()
    users_week, users_month = defaultdict(lambda: defaultdict(int)), defaultdict(lambda: defaultdict(int))
    is_week = d.weekday() == 6 or d == date.today() - timedelta(days=1)
    is_month = (d + timedelta(days=1)).day == 1 or d == date.today() - timedelta(days=1)
    loadTVMConfig(TVM)
    for j in range(1, d.day):
        di = d - timedelta(days=j)
        if is_week and not is_month and j > 6:
            break
        print("Parsing of compllog for date %s:" % di.isoformat()); sys.stdout.flush()
        try:
            f = open(COMPLLOG_FILE % (gethostname(), j))
        except IOError, e:
            writelog('File of compllog %s is absent' % (COMPLLOG_FILE % (gethostname(), j)), True)
            continue
        for row in f:
            sf = row.split("\t")
            if len(sf) < 17:
                if len(sf) > 4:
                    writelog("Error: Too few fields in row:\n%s" % row, False)
                l += 1; continue
            m = re.search(r'_(?:WS|WH|XX)', sf[5])
            if m:
                k += 1; continue
            try:
                m, m2 = re.match(r'(\d+)\.(\d+)\.(\d+)', sf[4]), re.match(r'(\d+)\.(\d+)\.(\d+)', sf[3])
                d1 = date(int(m.group(3)), int(m.group(2)), int(m.group(1))) if m else di     # дата жалобы
                d2 = date(int(m2.group(3)), int(m2.group(2)), int(m2.group(1))) if m2 else di # дата письма
                if d < d2:
                    print("Wrong message date in row:\n%s" % row)
                if (d1 - d2).days > 30: continue
                uids = sf[16].split(',')
                if sf[16] == '-' and sf[6] != '-':
                    i += 1; uids.append(getUID(sf[6]))
                mc = True if re.search(r'_MC', sf[5]) else False
                for uid in uids:
                    n += 1; m = re.match(r'\d+$', uid)
                    if not m or int(m.group(0)) < 1:
                        #print("Error in parsing uid: '%s'\n%s" % (sf[16], row)); sys.stdout.flush()
                        l += 1; continue
                    uid = m.group(0)
                    if is_month:
                        users_month['mobile' if mc else 'web'][uid] += 1
                        users_month['total'][uid] += 1
                    if is_week and di >= dw:
                        users_week['mobile' if mc else 'web'][uid] += 1
                        users_week['total'][uid] += 1
            except Exception, e:
                writelog("Error '%s' while parsing row:\n%s" % (str(e), row), True)
        f.close()

    print("Parsing done in %g sec. Saving data..." % (time() - t)); sys.stdout.flush(); t = time()
    if is_week:
        print("By week:  total = %d, web = %d, mobile = %d" % (len(users_week['total']), len(users_week['web']), len(users_week['mobile'])))
        dt, st = send_yastat('week', [{
                'fielddate': dw.isoformat(),
                'total':     len(users_week['total']),
                'web':       len(users_week['web']),
                'mobile':    len(users_week['mobile'])
            }])
        print("Sending week's data to YaStat done in %d sec with status %d" % (dt, st)); sys.stdout.flush()

    if is_month:
        print("By month: total = %d, web = %d, mobile = %d" % (len(users_month['total']), len(users_month['web']), len(users_month['mobile'])))
        dt, st = send_yastat('month', [{
                'fielddate': dm.isoformat(),
                'total':     len(users_month['total']),
                'web':       len(users_month['web']),
                'mobile':    len(users_month['mobile'])
            }])
        print("Sending month's data to YaStat done in %d sec with status %d" % (dt, st)); sys.stdout.flush()

    print('Sending done in %g sec: %d from %d are filtered out, %d parsings errors, %d have not uid' % (time() - t, k, k + n, l, i))

