#!usr/bin/awk
# -*- Encoding: utf-8 -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
$2 ~ /@/ { 
    gsub(/.*@/, "", $2);
    domn[$2]++
};

$7 ~ /_P3/ && $7~/_F0/ {
    sum[$2,"P3"]++
};

$7 ~ /_F0/ { 
    sum[$2,$3]++
}

END {
    print "domain", "TOTAL_fail", "TOTAL", "%of_TOTAL", "POP3_fail", "%P3_of_FAIL", "HAM_fail", "SPAM_fail"
    for (d in domn) {
        total_fail = sum[d SUBSEP "H"]+sum[d SUBSEP "D"]+sum[d SUBSEP "S"]+sum[d SUBSEP "M"];
        if (total_fail>0) print d, total_fail, 0+domn[d], 0+total_fail/domn[d]*100, 0+sum[d SUBSEP "P3"], 0+sum[d SUBSEP "P3"]/total_fail*100, 0+sum[d SUBSEP "H"]+sum[d SUBSEP "D"], 0+sum[d SUBSEP "S"]+sum[d SUBSEP "M"]
    }
}
