#!/usr/bin/env python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
def parse_rule(rule_filename):
    ret = []
    rulename, ruleregexp, rulefields = "", "", []
    for line in open(rule_filename):
        if len(line) < 3:
            rulename, ruleregexp, rulefields = "", "", []
        elif line.startswith("rule"):
            parts = line.split()
            rulename = parts[1]
        elif line.startswith("re"):
            ruleregexp = line.split()[-1].strip("/")
        elif line.startswith("field"):
            rulefields = line.split()[1:]
        elif line.startswith("describe"):
            for rulefield in rulefields:
                ret.append((line.split()[-1].upper(), rulefield.lower(), ruleregexp))
    return ret
