#!/bin/bash
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
DT=`date --date="yesterday" +%Y-%m-%d`
HOSTNAME=`hostname`
cd /tmp
awk -F "\t" '$6 ~ /_UF/' < "/u0/${HOSTNAME}/logs/shortdlv_in.log.1" > UF.log

cat UF.log | /opt/precast-shortlog-parser/unsubscribe_report.py domain | sort | uniq -c | sort -nr | awk '{ print $2, $3, $4, $5, $1 }' | column -t > UF.domain.log
cat UF.log | /opt/precast-shortlog-parser/unsubscribe_report.py domain suid | sort | uniq -c | sort -nr | awk '{ print $2, $3, $4, $5, $1 }' | column -t > UF.suid.domain.log

tar czvf unsubscribe.$DT.tar.gz UF.domain.log UF.suid.domain.log

echo "Report for $DT" | mail -s "Unsubscribe statistics $DT" -a unsubscribe.$DT.tar.gz so-report@yandex-team.ru

mv UF.domain.log /u0/unsubscribe/UF.domain.log_$DT
mv UF.suid.domain.log /u0/unsubscribe/UF.suid.domain.log_$DT
rm -f unsubscribe.$DT.tar.gz
rm -f UF.log
