#!/usr/bin/env python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from __future__ import print_function
import sys, re
from datetime import date, timedelta, datetime
from socket import gethostname
from common import get_traceback

LOG_FILE = "/var/log/so-logs/corp-fake-domains-" + sd0
SHORTLOG_FILE = '/u0/%s/logs/shortdlv_corp.log' % gethostname() + (".%d" % N if N > 0 else '')

def log(msg, isTB = False, end = '\n'):
    try:
        print("[%s] %s%s" % (datetime.today().strftime("%Y-%m-%d %H:%M:%S"), msg, get_traceback() if isTB else ''))
        sys.stdout.flush()
    except Exception, e:
        print("Exception while writing log: %s.%s" % (str(e), get_traceback()), file=sys.stderr)

sd0, N = sys.argv[1] if len(sys.argv) > 1 else (date.today() - timedelta(days = 1)).isoformat(), 1
try:
    d0 = datetime.strptime(sd0, '%Y-%m-%d').date()
    sd0, N = d0.isoformat(), (date.today() - d0).days
except Exception, e:
    log("Error while parsing date string '%s': %s" % (sd0, str(e)), True)
    sys.exit(1)

log("Processing file '%s':" % SHORTLOG_FILE, end = " ")
f_out, n = open(LOG_FILE, 'at'), 0
with open(SHORTLOG_FILE) as f:
    for row in f:
        sf = row.split("\t")
        m1 = re.search(r'[^@\s]+@([^@\s]*\byandex-team\.(?:ru|com|com\.ua|com\.tr))$', sf[0])
        m2 = re.search(r'[^@\s]+@([^@\s]*\byandex-team\.(?:ru|com|com\.ua|com\.tr))$', sf[1])
        if sf[5].find('_ZY') < 0 and (m1 and not m2 or not m1 and m2 or m1 and m2 and (m1.group(1) != m2.group(1) or sf[5].find('_SP', ) < 0 or sf[5].find('_DP') < 0)):
            print(row, file = f_out)
            n += 1
f_out.close()
log("[ Done: %d events ]" % n)
