#!/usr/bin/env python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
from __future__ import print_function
import sys, email, subprocess
from datetime import date, timedelta, datetime
from socket import gethostname
from common import get_traceback, sendEmail

def log(msg, isTB = False, end = '\n'):
    try:
        print("[%s] %s%s" % (datetime.today().strftime("%Y-%m-%d %H:%M:%S"), msg, get_traceback() if isTB else ''))
        sys.stdout.flush()
    except Exception, e:
        print("Exception while writing log: %s.%s" % (str(e), get_traceback(), file=sys.stderr)

def remainder(n):
    s, m, k = 'й', n % 10, n % 100 // 10
    if m == 1 and k != 1:
        s = 'е'
    elif m > 1 and m < 5 and k != 1:
        s = 'я'
    return s

sd0 = sys.argv[1] if len(sys.argv) > 1 else date.today().isoformat()
try:
    d0 = datetime.strptime(sd0, '%Y-%m-%d').date() - timedelta(days = 1)
    sd0 = d0.isoformat()
except Exception, e:
    log("Error while parsing date string '%s': %s" % (sd0, str(e)), True)
    sys.exit(1)

SHORTLOG_FILE = '/u0/%s/logs/shortdlv_out.log.1' % gethostname()
TARGET_EMAIL = 'security-alerts@yandex-team.ru'

txt, n = "<html>\n<body>\n<p>Подробности смотри <a href='https://st.yandex-team.ru/SODEV-471'>здесь</a><p>\n", 0
txt_table = "<table cellspacing='0' cellpadding='2' border='1' width='100%'>\n" \
    "<tr><th>Время</th><th>Ориг.имя ящика</th><th>From</th><th>IP отправителя</th><th>Заключение СО</th></tr>"
log("Processing file '%s':" % SHORTLOG_FILE, end = " ")
with open(SHORTLOG_FILE) as f:
    for row in f:
        sf = row.split("\t")
        if sf[2].find('yandex-team.ru') >= 0:
            txt_table += "<tr><td>%s</td><td>%s</td><td>%s</td><td align='center'>%s</td><td align='center'>%s</td></tr>\n" \
            % (sf[6], sf[1], sf[2], sf[9], sf[3])
            n += 1
log("[ Done ]")
txt_table += "</table>\n"
if n > 0:
    txt += txt_table
txt += "<p>Всего: %d событи%s</p></body>\n</html>" % (n, remainder(n))
msg = email.message_from_string(txt)
msg['Content-Type'] = 'text/html'
msg['From'] = 'noreplay@yandex-team.ru'
msg['To'] = TARGET_EMAIL
msg['Subject'] = 'Спамооборона: Список событий отправки почты от имени y-t за %s' % sd0
sendEmail(msg.as_string(), toaddr=TARGET_EMAIL)

log("Message has sended to '%s' successfully. Found %d events." % (TARGET_EMAIL, n))
