#!/usr/bin/awk -f
# -*- Encoding: utf-8 -*-
# kate: space-indent on; indent-width 2; replace-tabs on;
#
# Used: awk -f daily-report.awk checkmessages-access.log
#
# $6  : request uri
# $8  : answer|error code
# $NF : request time

BEGIN {
    name=0
    split( "CHECKMESSAGES UNKNOWN", services, " " )
    for( i in services ) {
        service[ services[ i ] ] = 0
        min100ms[ services[ i ] ] = 0
        min100ms[ "Total" ] = 0
        min200ms[ services[ i ] ] = 0
        min200ms[ "Total" ] = 0
        min500ms[ services[ i ] ] = 0
        min500ms[ "Total" ] = 0
        min1sec[ services[ i ] ] = 0
        min1sec[ "Total" ] = 0
        more1sec[ services[ i ] ] = 0
        more1sec[ "Total" ] = 0
        ercode[ services[ i ] ] = 0
        ercode[ "Total" ] = 0
    }
}

function print_array(myArray){
    for (i in myArray) tmpidx[sprintf("%12s", i),i] = i
    num = asorti(tmpidx)
    j = 0
    for (i=1; i<=num; i++) {
      split(tmpidx[i], tmp, SUBSEP)
      indices[++j] = tmp[2]  # tmp[2] is the name
    }
    for (i=1; i<=num; i++)
      if (indices[i] != "") {
        printf("<tr><td>%-10s</td><td>%s</td></tr>\n", indices[i], myArray[indices[i]])
      }
}

function print_servicestat(myArray, myArray2){
    for (i in myArray) tmpidx[sprintf("%12s", i),i] = i
    num = asorti(tmpidx)
    j = 0
    for (i=1; i<=num; i++) {
      split(tmpidx[i], tmp, SUBSEP)
      indices[++j] = tmp[2]  # tmp[2] is the name
    }
    for (i=1; i<=num; i++)
      if (indices[i] != "") {
        if(myArray[ indices[ i ] ] != 0)
          percent = 100.0 * myArray2[indices[i]]/myArray[indices[i]];
        else
          percent = 0;
        printf("<tr><td>%-10s</td><td>%-10s</td><td>%5.2f</td></tr>\n", indices[i], myArray[indices[i]], percent)
      }
}

function add_info(name, http_code, timeout){
    service[name]++
    if (http_code != ""){
        code[http_code]++
    }
    if (http_code != 200){
        ercode[name]++
        ercode["Total"]++
    }
    if (timeout <= 0.1){
        min100ms[name]++
        min100ms["Total"]++
    } else if (timeout <= 0.2 && timeout > 0.1){
        min200ms[name]++
        min200ms["Total"]++
    } else if (timeout <= 0.5 && timeout > 0.2){
        min500ms[name]++
        min500ms["Total"]++
    } else if (timeout <= 1 && timeout > 0.5){
        min1sec[name]++
        min1sec["Total"]++
    } else {
        more1sec[name]++
        more1sec["Total"]++
        #query[timeout, name] = $9
    }
}

$5 ~ /"POST/ {
    http_code=$8
    n=match($9, /(\Wso_service=)([^&]*)/, ss)
    name=toupper(ss[2])

    add_info(name, http_code, $NF)
}

END {
    print "Content-Type: text/html; charset='utf-8'"
    print "MIME-Version: 1.0"
    print "Content-Transfer-Encoding: 8bit"
    print "From: Robot Mailspam <robot-mailspam@yandex-team.ru>"
    print "To: so-report@yandex-team.ru"
    printf("Subject: [%s] Checkmessages: Daily report\n", strftime("%Y-%m-%d", systime() - 86400))
    print ""
    print "<html>"
    print "<head>"
    print "<meta http-equiv='Content-Type' content='text/html; charset=utf-8' />"
    print "</head>"
    print "<body>"
    
    print "<h3>Requests by service</h3>"
    print "<table cellspacing='4' cellpadding='8'><thead><tr><td><b>Service</b></td><td><b>Total</b></td><td><b>Error %</b></td></tr>"
    print_servicestat(service, ercode)
    print "</tr></tbody></table><br />"
    
    print "<h3>Codes by answers</h3>"
    print "<table cellspacing='4' cellpadding='8'><thead><tr><td><b>HTTP code</b></td><td><b>Count</b></td></tr></thead><tbody><tr>"
    print_array(code)
    print "</tr></tbody></table><br />"
    if (ercode["Total"] > 0) {
      print "<h3>Errors count by service</h3>"
      print "<table cellspacing='4' cellpadding='8'><thead><tr><td><b>Service</b></td><td><b>Errors count</b></td></tr></thead><tbody><tr>"
      print_array(ercode)
      print "</tr></tbody></table><br />"
    } else {
      print "<h3>Errors count by service: no errors</h3>"
    }
    if (min100ms["Total"] > 0) {
      print "<h3>Request timeout &lt; 0.100s</h3>"
      print "<table cellspacing='4' cellpadding='8'><thead><tr><td><b>Service</b></td><td><b>Requests count</b></td></tr></thead><tbody><tr>"
      print_array(min100ms)
      print "</tr></tbody></table><br />"
    } else {
      print "<h3>Request timeout &lt; 0.100s: no requests</h3>"
    }
    if (min200ms["Total"] > 0) {
      print "<h3>Request timeout &gt; 0.100s and &lt; 0.200s</h3>"
      print "<table cellspacing='4' cellpadding='8'><thead><tr><td><b>Service</b></td><td><b>Requests count</b></td></tr></thead><tbody><tr>"
      print_array(min200ms)
      print "</tr></tbody></table><br />"
    } else {
      print "<h3>Request timeout &gt; 0.100s and &lt; 0.200s: no requests</h3>"
    }
    if (min500ms["Total"] > 0) {
      print "<h3>Request timeout &gt; 0.200s and &lt; 0.500s</h3>"
      print "<table cellspacing='4' cellpadding='8'><thead><tr><td><b>Service</b></td><td><b>Requests count</b></td></tr></thead><tbody><tr>"
      print_array(min500ms)
      print "</tr></tbody></table><br />"
    } else {
      print "<h3>Request timeout &gt; 0.200s and &lt; 0.500s: no requests</h3>"
    }
    if (min1sec["Total"] > 0) {
      print "<h3>Request timeout &gt; 0.500s and &lt; 1sec</h3>"
      print "<table cellspacing='4' cellpadding='8'><thead><tr><td><b>Service</b></td><td><b>Requests count</b></td></tr></thead><tbody><tr>"
      print_array(min1sec)
      print "</tr></tbody></table><br />"
    } else {
      print "<h3>Request timeout &gt; 0.500s and &lt; 1sec: no requests</h3>"
    }
    if (more1sec["Total"] > 0) {
      print "<h3>Request timeout &gt; 1sec</h3>"
      print "<table cellspacing='4' cellpadding='8'><thead><tr><td><b>Service</b></td><td><b>Requests count</b></td></tr></thead><tbody><tr>"
      print_array(more1sec)
      print "</tr></tbody></table><br />"
    } else {
      print "<h3>Request timeout &gt; 1sec: no requests</h3>"
    }
#    print "<h3>Slow requests by service</h3>"
#    print "<table width=100%><thead><tr><td>Service</td><td>Requests count</td></tr>"
#    for (i in query) {
#	    split(i,sep,SUBSEP);
#	    print sep[2], sep[1], query[sep[1],sep[2]],  "\n";
#    }
#   print "</table><br />"
    print "</body>"
    print "</html>"
}
