#!/usr/bin/env python2

import sys, time, glob, re
sys.path.insert(0, '/opt/precast-socheckmessageslog-parser')
from collections import defaultdict
from socket import gethostname
from so_log_tail import LogTail

KEY_PREFIX = "so.checkmessages"
PARSE_PERIOD = 240

stat = defaultdict(lambda: defaultdict(float))

for filename in glob.glob("/u0/%s/usr/local/www/logs/SO_CHECKMESSAGES/*/delivery.log" % gethostname()):
    LOG_TAIL = LogTail(None, log=filename, id='checkmessagesparser')
    timestamp, service, malic, dirty, spam = 0, "", False, False, False
    for line in LOG_TAIL():
        if len(line) < 5:
            if service:
                if spam == "yes":
                    stat[timestamp]["%s.spam" % service] += 1
                else:
                    stat[timestamp]["%s.ham" % service] += 1
                if malic:
                    stat[timestamp]["%s.malic" % service] += 1
                if dirty:
                    stat[timestamp]["%s.dirty" % service] += 1
            timestamp, service, malic, dirty, spam = 0, "", False, False, False
        elif line.startswith("mess:"):
            timestamp = int(int(line.split()[5].strip(":")) / PARSE_PERIOD) * PARSE_PERIOD
        elif line.startswith("*srvc:"):
            service = line[7:].strip()
        elif line.startswith("spam:"):
            spam = line.split()[1]
        elif line.startswith("r_"):
            dirty = dirty or line.find("DIRTYWORD,") >= 0
            malic = malic or line.find("BLOCKRULE,") >= 0

filename = "/u0/%s/usr/local/www/logs/SO_CHECKMESSAGES/sendanswer.log" % gethostname()
LOG_TAIL = LogTail(None, log=filename, id='checkmessagesparser_sa')
lastline = ""
for line in LOG_TAIL():
    timestamp, service = 0, ""
    if re.search(r"\r\n?$", line):
        lastline = re.sub(r"\r\n?$", "", line)
        continue
    else:
        line = lastline + line
        lastline = ""
    m = re.search(r"##\d+-(?P<timestamp>\d{10}).*\s(?P<service>[A-Z]+) - FASTREJECT", line)
    if m:
        timestamp = int(int(m.group("timestamp")) / PARSE_PERIOD) * PARSE_PERIOD
        service = m.group("service")
        stat[timestamp]["%s.fastreject" % service] += 1

buf = ""
for timestamp, info in sorted(stat.iteritems()):
    for name, count in sorted(info.iteritems()):
        buf += "%s.%s %f %d\n" % (KEY_PREFIX, name, count, timestamp)
print buf
sys.stdout.flush()
