#!/usr/bin/env python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, re, sys, time, fcntl
from collections import defaultdict
from datetime import datetime
from socket import gethostname
from common import get_traceback
from so_log_tail import LogTail
from mongodb import loadMongoDbCredentials, getMongoDB

PIDFILE = "/var/run/parse_journal_sopassport_dlv.pid"
CHPASS_TYPES = {"CHANGE_PASSWORD": 4, "CHANGE_PASSWORD_FORCE": 5, "CHANGE_PASSWORD_STRONG": 6, "CHANGE_PASSWORD_VOLUNTARILY": 7}
HACKED_BY_RULE = 4
LOGFILE = "/u0/%s/usr/local/www/logs/SO_FRODOOBORONA/delivery.log" % gethostname()
MONGO = {
    'db':      'journal',
    'hosts':   'sas-fxovfnlkhpwojehr.db.yandex.net,vla-f8vat6i2dl9fz4vc.db.yandex.net,man-28m87k85xm5ejgqn.db.yandex.net',
    'port':    27018,
    'user':    'journal',
    'timeout': 60000
}

def check_pid(filename):
    check_pid.file = open(filename, "w")
    try:
        fcntl.lockf(check_pid.file, fcntl.LOCK_EX | fcntl.LOCK_NB)
    except IOError:
        return False
    print >>check_pid.file, os.getpid()
    return True

def parse_date(date_str):
    if not hasattr(parse_date, "cache"):
        parse_date.cache = {}
    if date_str not in parse_date.cache:
        parse_date.cache[date_str] = int(time.mktime(time.strptime(date_str, "%Y.%m.%d")))
    return parse_date.cache[date_str]

def get_chpass_type(s):
    if s in CHPASS_TYPES:
        return CHPASS_TYPES[s]
    return 0

if not check_pid(PIDFILE):
    print datetime.today().strftime("[%Y-%m-%d %H:%M:%S]"), "parse_journal_sopassport_dlv already running"
    exit()

LOG_TAIL = LogTail(None, log=LOGFILE, id='journal')
stat, uids = defaultdict(int), set()
total, errors = 0, 0
re_rtim = re.compile("\((\d+)\)")
chpass_type, uid, date = 0, 0, 0

for line in LOG_TAIL():
    total += 1
    try:
        if len(line) < 3:
            if chpass_type > 0 and date > 0:
                stat[(date, uid, chpass_type)] += 1
                uids.add(uid)
            chpass_type = 0
            uid, date = 0, 0
        elif line.startswith("rtyp:"):
            chpass_type = get_chpass_type(line[6:].strip())
        elif line.startswith("uid :"):
            uid = int(line[6:].strip())
        elif line.startswith("rtim:"):
            date = line.split()[1]
    except Exception, e:
        errors += 1
try:
    loadMongoDbCredentials(MONGO)
    db = getMongoDB(MONGO)
    for uid in uids:
        try:
            db["users"].update_one({"uid": uid}, {"$set": {"uid": uid}}, upsert = True)
        except:
            errors += 1
    for (date, uid, chpass_type), count in sorted(stat.iteritems()):
        try:
            db["journal"].insert_one({"date": parse_date(date), "uid": uid, "type": chpass_type}, continue_on_error = True)
        except:
            errors += 1
except Exception, e:
    print >>sys.stderr, "Exception while DB operations: %s.%s" % (str(e), get_traceback())

print datetime.today().strftime("[%Y-%m-%d %H:%M:%S]"), "Parsing done. Total lines: %d. Errors: %d" % (total, errors)
