#!/usr/bin/env python2
#
import sys, re
sys.path.insert(0, '/opt/precast-sosearchlog-parser')
from collections import defaultdict
from socket import gethostname
from common import get_traceback
from so_log_tail import LogTail

KEY_PREFIX = "so.search"
PARSE_PERIOD = 60
LOGFILE = "/u0/%s/usr/local/www/logs/SO_MSEARCHPROXY/MSEARCH-PROXY/delivery.log" % gethostname()

stat, imap = defaultdict(lambda: defaultdict(int)), defaultdict(bool)
timestamp, spam, badgeo, whitegeo, malic = 0, False, False, False, False
re_timestamp = re.compile("\-\s*(\d+):")
LOG_TAIL = LogTail(None, log=LOGFILE, id='sosearch_delivery')
for line in LOG_TAIL():
    try:
        if len(line) < 3:
            if timestamp > 0:
                timestamp_round = int(timestamp / PARSE_PERIOD) * PARSE_PERIOD
                if malic:
                    stat[timestamp_round]["malic"] += 1
                else:
                    stat[timestamp_round]["spam"] += 1 if spam else 0
                    stat[timestamp_round]["ham"] += 0 if spam else 1
                stat[timestamp_round]["badgeo"] += 1 if badgeo else 0
                stat[timestamp_round]["whitegeo"] += 1 if whitegeo else 0
                stat[timestamp_round]["imap0"] += 1 if imap["0"] else 0
                stat[timestamp_round]["imap1"] += 1 if imap["1"] else 0
                stat[timestamp_round]["imap2"] += 1 if imap["2"] else 0
            timestamp, spam, badgeo, whitegeo, malic = 0, False, False, False, False
            imap = defaultdict(bool)
        elif line.startswith("mess"):
            match_timestamp = re_timestamp.search(line)
            if match_timestamp:
                timestamp = int(match_timestamp.group(1))
        elif line.startswith("spam"):
            spam = line.find("yes") >= 0
        elif line.startswith("*imap"):
            imap[line[7:-1]] = True
        elif line.startswith("r_nl"):
            badgeo = line.find(" BAD_GEO_ZONE,") >= 0
            whitegeo = line.find(" IS_WHITE_LIST,") >= 0
            malic = line.find(" BLOCKRULE,") >= 0
    except Exception, e:
        print >>sys.stderr, "Exception: %s.%s" % (str(e), get_traceback())
buf = ""
for timestamp, info in sorted(stat.iteritems()):
    for name, count in sorted(info.iteritems()):
        buf += "%s.%s %d %d\n" % (KEY_PREFIX, name, count, timestamp)
print buf
sys.stdout.flush()
