#!/usr/bin/python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))

import urllib2, json
from socket import getfqdn
from common import writelog

DEFAULT_LOG = '/logs/logdata-sender.log'
rows, q = '', {}

for line in sys.stdin:
    rows += line
try:
    q = json.loads(rows)
except Exception, e:
    writelog("Error while decoding JSON from input stream: %s" % str(e), True)
    sys.exit(1)

if not (isinstance(q, dict) and 'host' in q and 'dataResult' in q):
    writelog("Input data has wrong format!")
    sys.exit(1)

attemptsNumber, attemptsTimeOut = q.get('attemptsNumber', 10), q.get('attemptTimeOut', 2)
if 'errorsLogFile' not in q:
    q['errorsLogFile'] = DEFAULT_LOG

log_fh = open(q['errorsLogFile'], 'w+t')

for i in range(attemptsNumber):
    try:
        response = urllib2.urlopen(urllib2.Request('http://%s:%s%s' % (q['host'], q.get('port', 80), q.get('requestUri', '')), json.dumps(q['dataResult']),
                                                   {'Log': q.get('log', ''), 'Remote-Host': q.get('machine', getfqdn()), 'Log-Data': json.dumps(q['logData']) if 'logData' in q else ''}),
                                  None, q.get('httpTimeOut', 30))
        if not response or response.getcode() != 200:
            writelog("Attempt %s. Response [pid=%s]:\n\tcode: %s, info: %s" % (i + 1, os.getpid(), response.getcode(), response.info()), fh=log_fh)
        else:
            break
    except urllib2.HTTPError, e:
        writelog("Attempt %s. Response [pid=%s]:\n\tcode: %s, info: %s." % (i + 1, os.getpid(), e.code, e.reason), True, fh=log_fh)
    except Exception, e:
        writelog("Attempt %d. Error while POST-request [pid=%s]: %s." % (i + 1, os.getpid(), str(e)), True, fh=log_fh)
log_fh.close()
