#!/usr/bin/env python2.7
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys
from pymongo import MongoClient
from logger import error
from common import getHosts4Group

def mongoConnStr(cfg, params={}):
    s, hosts, hosts_str, params_str = '', cfg.get('hosts', '127.0.0.1').split(','), "", ""
    if "user" in cfg and cfg['user']:
        s = "{}:{}@".format(cfg['user'], cfg['passwd'])
    if params:
        params_str = '?' + '&'.join(map(lambda it: "{}={}".format(*it), params.items()))
    if "port" in cfg and cfg.get("port", "27017") != "27017":
        hosts_str = ','.join(map(lambda host: "{}:{}".format(host, cfg["port"]), getHosts4Group(cfg.get('cluster', ''), hosts)))
    else:
        hosts_str = ','.join(getHosts4Group(cfg.get('cluster', ''), hosts))
    return "mongodb://{}{}/{}{}".format(s, hosts_str, cfg['db'], params_str)

def loadMongoDbCredentials(cfg):
    f, CURDIR = None, 'WORKING_DIR'
    try:
        if not os.path.exists('%s/.mongodb.%s' % (CURDIR, cfg['db'])):
            CURDIR = os.path.dirname(os.path.abspath(__file__))
            if not os.path.exists('%s/.mongodb.%s' % (CURDIR, cfg['db'])):
                CURDIR = os.environ['HOME'] if 'HOME' in os.environ else '/root'
        if os.path.exists('%s/.mongodb.%s' % (CURDIR, cfg['db'])):
            f = open('%s/.mongodb.%s' % (CURDIR, cfg['db']))
            for line in f:
                sf = line.split(':')
                if len(sf) == 2:
                    cfg['user'], cfg['passwd'] = sf[0], sf[1].strip()
                    break
            f.close()
        elif 'user' in cfg:
            error("Unable to locate file with DB credentials!", False)
    except Exception, e:
        error("loadMongoDbCredentials exception: %s" % str(e))

def getMongoDB(cfg, params={}):
    if not hasattr(getMongoDB, "%s_connection" % cfg['db']):
        timeout = cfg['timeout'] if 'timeout' in cfg and cfg['timeout'] else 10000
        if "connectTimeoutMS" not in params:
            params["connectTimeoutMS"] = timeout
        if "socketTimeoutMS" not in params:
            params["socketTimeoutMS"] = timeout
        setattr(getMongoDB, "%s_connection" % cfg['db'], MongoClient(mongoConnStr(cfg, params))[cfg['db']])
    return getattr(getMongoDB, "%s_connection" % cfg['db'])

