#!/bin/bash
THRESHOLD=99
MAX_VOL_USAGE=$(df -h | grep "/dev/md[12]" | awk '$5 ~ /[0-9]+/ {print $5}' | sed -e 's/%//' | sort -nr | head -n1)
[ "$MAX_VOL_USAGE" -lt "$THRESHOLD" ] && exit 0

OLDEST_SO_IN_LOG_FILE=$(find /u0/statlog/so_in/so_in*.log -type f | sort | head -n1)
OLDEST_SO_OUT_LOG_FILE=$(find /u0/statlog/so_out/so_out*.log -type f | sort | head -n1)
OLDEST_SO_CORP_LOG_FILE=$(find /u0/statlog/so_corp/so_corp*.log -type f | sort | head -n1)

LOGS_TO_DELETE=(
"/var/log/nginx/statlog/access-in.log.1"
"/var/log/nginx/statlog/access-out.log.1"
"/var/log/nginx/statlog/access-corp.log.1"
"$OLDEST_SO_IN_LOG_FILE"
"$OLDEST_SO_OUT_LOG_FILE"
"$OLDEST_SO_CORP_LOG_FILE"
)

calc_u0_usage() {
    U0_USAGE=$(df -h | awk '$6 == "/u0" {print $5}' | sed -e 's/%//' | sort -nr | head -n1)
    [ -z "$U0_USAGE" ] && U0_USAGE=$(df -h | awk '$6 == "/" {print $5}' | sed -e 's/%//' | sort -nr | head -n1)
}

for file in ${LOGS_TO_DELETE[@]}; do
    calc_u0_usage
    if [ "$U0_USAGE" -ge "$THRESHOLD" ]; then
        [ -e "$file" ] && rm -f "$file" && sleep 2
    else
        break
    fi
done
