#!/usr/bin/env python
#-*- coding: utf-8 -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import sys
import syslog
import logging
from traceback import format_exception

def get_traceback():
    exc_type, exc_value, exc_traceback = sys.exc_info()
    tb = ''
    for step in format_exception(exc_type, exc_value, exc_traceback):
        try:
            tb += "\t" + step.strip() + "\n"
        except:
            pass
    return tb


class NullFilter(logging.Filter):
    def filter(self, record):
        return False

def configure(ident):
    syslog.openlog(ident, syslog.LOG_PID | syslog.LOG_NDELAY)

    acc_log = logging.getLogger("tornado.access")
    app_log = logging.getLogger("tornado.application")
    gen_log = logging.getLogger("tornado.general")

    handler = logging.handlers.SysLogHandler(address="/dev/log")
    formatter = logging.Formatter("%(asctime)s " + ident + "[%(process)d]: %(message)s", datefmt="%b %d %H:%M:%S")
    handler.setFormatter(formatter)

    acc_log.addFilter(NullFilter())
    app_log.addHandler(handler)
    gen_log.addHandler(handler)

def trace(s):
    syslog.syslog(syslog.LOG_NOTICE, s)

def access(s):
    syslog.syslog(syslog.LOG_NOTICE, s)

def action(s):
    syslog.syslog(syslog.LOG_NOTICE, s)

def error(s, isTB=True):
    tb = "\n"
    if isTB:
        tb += get_traceback()
    syslog.syslog(syslog.LOG_ERR, "ERROR: {}".format(s + tb))

