#!/usr/bin/env python
#-*- coding: utf-8 -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os
import json
import string
from datetime import datetime
from collections import defaultdict
from tornado.gen import coroutine, Return
from logdumper import ip_to_integer
from db import getMongoDB
from logger import error


def restoreDlvLog(data_str):
    if data_str[0] == '[': # expecting of array in JSON format
        log, data = "", []
        try:
            data = json.loads(data_str)
        except Exception, e:
            try:
                data = json.loads(unicode(data_str, 'utf8', 'replace'))
            except Exception, e:
                error("Parsing of JSON failed: %s" % str(e))
        for t in data:
            log += t[0] + ": " + t[1] + "\n"
        return log
    elif data_str[0] == '{': # expecting of dict in JSON format
        log, data = "", {}
        try:
            data = json.loads(data_str)
        except Exception, e:
            error("Parsing of JSON failed: %s" % str(e))
        for k, v in data.iteritems():
            if isinstance(v, list):
                for it in v:
                    log += k + ": " + it + "\n"
            else:
                log += k + ": " + v + "\n"
        return log
    else:
        return data_str


class LogReader(object):
    def __init__(self, sotype, path):
        self.db = getMongoDB({"db": "solog"}, {"maxPoolSize": 512})
        self.sotype = sotype
        self.path = path
        self.filecache = {}

    def reload(self):
        self.filecache = {}

    @coroutine
    def getByQid(self, qid, mid, timestamp):
        datestr, query = datetime.fromtimestamp(timestamp).strftime("%Y%m%d"), {}
        if qid:
            query = {"qid": qid}
        elif mid:
            query = {"mid": mid}
        else:
            raise Return("")
        log = yield self.queryFromDB("so_%s%s" % (self.sotype, datestr), query)
        raise Return(log)

    @coroutine
    def getRange(self, timestamp, codes, locl, qidmid, ip, uid, suid, limit):
        datestr = datetime.fromtimestamp(timestamp).strftime("%Y%m%d")
        query = {}
        if codes:
            query["code"] = {"$in": codes}
        if locl:
            query["locl"] = locl
        if qidmid:
            if qidmid.find("@") >= 0:
                query["mid"] = qidmid
            else:
                query["qid"] = qidmid
        if uid:
            query["uid"] = uid
        if suid:
            query["suid"] = suid
        if ip:
            query["ip"] = ip_to_integer(ip)
        logs = yield self.queryRangeFromDB("so_%s%s" % (self.sotype, datestr), query, 0, limit, [("offset", -1)])
        raise Return("".join(logs))

    @coroutine
    def getRangeEx(self, time_constraint, codes, locl, qidmid, ip, uid, suid, rcpt_uid, fromaddr, routes, limit, skip):
        mindate, maxdate, ts_filter = None, None, None
        if time_constraint:
            if isinstance(time_constraint, dict):
                ts_filter = {}
                if 'mintime' in time_constraint:
                    ts_filter['$gte'] = time_constraint['mintime']
                    mindate = datetime.fromtimestamp(time_constraint['mintime']).strftime("%Y%m%d")
                if 'maxtime' in time_constraint:
                    ts_filter['$lte'] = time_constraint['maxtime']
                    maxdate = datetime.fromtimestamp(time_constraint['maxtime']).strftime("%Y%m%d")
            else:
                mindate = maxdate = datetime.fromtimestamp(float(time_constraint)).strftime("%Y%m%d")
        found = defaultdict(int)
        result = {}
        for name in sorted(self.db.collection_names(False), reverse=True):
            if routes and name[3:-8] not in routes:
                continue
            datestr = name[-8:]
            if mindate and datestr < mindate:
                continue
            if maxdate and datestr > maxdate:
                continue
            logtype = name[:-8]
            limit_current = limit - found[logtype]
            if limit_current <= 0:
                continue
            query = {}
            if ts_filter and len(ts_filter) > 0:
                query["ts"] = ts_filter
            if codes:
                query["code"] = {"$in": map(str, codes)}
            if locl:
                query["locl"] = locl
            if qidmid:
                if qidmid.find("@") >= 0:
                    query["mid"] = qidmid
                else:
                    query["qid"] = qidmid
            if uid:
                query["uid"] = uid
            if suid:
                query["suid"] = suid
            if rcpt_uid:
                query["rcpt_uid"] = rcpt_uid
            if fromaddr:
                query["fr"] = fromaddr
            if ip:
                query["ip"] = ip_to_integer(ip)
            logs = yield self.queryRangeFromDB(name, query, skip, limit_current, [("ts", -1), ("offset", -1)])
            found[logtype] += len(logs)
            result[name] = logs
        raise Return(json.dumps(result))

    @coroutine
    def getJson(self, offsets):
        logs, datestr = [], datetime.today().strftime("%Y%m%d")
        for offset in offsets:
            log = yield self.queryFromDB("so_%s%s" % (self.sotype, datestr), {"offset": offset})
            if log:
                logs.append(log)
        raise Return(json.dumps(logs))

    @coroutine
    def queryRangeFromDB(self, name, query, skip, limit, sort):
        logs, filename, logtype = [], "%s.log" % name, name[:-8]
        try:
            for obj in self.db[name].find(query, skip=skip, limit=limit, sort=sort):
                if filename not in self.filecache:
                    pathroot = "/%s" % "/".join(filter(len, map(string.strip, self.path.split("/")))[:-1])
                    self.filecache[filename] = open(os.path.join(pathroot, logtype, filename), "rt")
                f = self.filecache[filename]
                f.seek(obj["offset"])
                logs.append(restoreDlvLog(f.read(obj["size"]).decode("koi8-r")))
        except Exception, e:
            error("queryRangeFromDB exception: %s" % str(e))
        raise Return(logs)

    @coroutine
    def queryFromDB(self, name, query):
        log, filename = "", "%s.log" % name
        try:
            obj = self.db[name].find_one(query)
            if obj:
                if filename not in self.filecache:
                    self.filecache[filename] = open(os.path.join(self.path, filename), "rt")
                f = self.filecache[filename]
                f.seek(obj["offset"])
                log = restoreDlvLog(f.read(obj["size"]).decode("koi8-r"))
        except Exception, e:
            error("queryFromDB exception: %s" % str(e))
        raise Return(log)
