#!/bin/bash
# kate: space-indent on; indent-width 4; replace-tabs on;
#
logs=(
/var/log/nginx/statlog/access.log
/var/log/nginx/statlog/error.log
)

# Rotate old logs
for log in ${logs[@]} ; do
    for i in 1 0 ; do
        [ -f $log.$i ] && mv -f $log.$i $log.`expr $i + 1` 2>/dev/null
    done
done

# Rotate actual log
for log in ${logs[@]} ; do
    [ -f $log ] && mv $log $log.0
done

# Reload services, when logs rotated
[ -x /etc/init.d/nginx ] && /etc/init.d/nginx reload > /dev/null
