#!/usr/bin/perl -w

my $hostname = `uname -n`;
$hostname =~ s/\./_/g;
chomp $hostname;

my $timestemp = time;
my $app = 'nginx-statlog';

my $nginxstatlogcode1xx = 0;
my $nginxstatlogcode2xx = 0;
my $nginxstatlogcode3xx = 0;
my $nginxstatlogcode4xx = 0;
my $nginxstatlogcode5xx = 0;
my $nginxstatlogcodeunknown = 0;

my $nginxstatloganswer0x003 = 0;
my $nginxstatloganswer003x01 = 0;
my $nginxstatloganswer01x05 = 0;
my $nginxstatloganswer05x1 = 0;
my $nginxstatloganswer1xinf = 0;

open (ACCESSLOG, "/opt/bin/so-log-tail.pl /var/log/nginx/statlog/access.log $app |");

while (<ACCESSLOG>)
{
        if (/HTTP" (\d+) "/) {
                if ($1 < 200) {
                        $nginxstatlogcode1xx++;
                } elsif ($1 < 300) {
                        $nginxstatlogcode2xx++;
                } elsif ($1 < 400) {
                        $nginxstatlogcode3xx++;
                } elsif ($1 < 500) {
                        $nginxstatlogcode4xx++;
                } elsif ($1 < 600) {
                        $nginxstatlogcode5xx++;
                } else {
                        $nginxstatlogcodeunknown++;
		}
                if (/HTTP" (\d+) ".* (\d+) (\d+) (\d+\.\d+)$/) {
                        if ($4 <= 0.003) {
                                $nginxstatloganswer0x003++;
                        } elsif ($4 <= 0.01) {
                                $nginxstatloganswer003x01++;
                        } elsif ($4 <= 0.5) {
                                $nginxstatloganswer01x05++;
                        } elsif ($4 <= 1) {
                                $nginxstatloganswer05x1++;
                        } else {
                                $nginxstatloganswer1xinf++;
                        }
                }
        }
}

close ACCESSLOG;

print "so_statlog.$hostname.nginx.statlog.code.1xx $nginxstatlogcode1xx $timestemp\n";
print "so_statlog.$hostname.nginx.statlog.code.2xx $nginxstatlogcode2xx $timestemp\n";
print "so_statlog.$hostname.nginx.statlog.code.3xx $nginxstatlogcode3xx $timestemp\n";
print "so_statlog.$hostname.nginx.statlog.code.4xx $nginxstatlogcode4xx $timestemp\n";
print "so_statlog.$hostname.nginx.statlog.code.5xx $nginxstatlogcode5xx $timestemp\n";
print "so_statlog.$hostname.nginx.statlog.code.unknown $nginxstatlogcodeunknown $timestemp\n";

print "so_statlog.$hostname.nginx.statlog.answer.0x003 $nginxstatloganswer0x003 $timestemp\n";
print "so_statlog.$hostname.nginx.statlog.answer.003x01 $nginxstatloganswer003x01 $timestemp\n";
print "so_statlog.$hostname.nginx.statlog.answer.01x05 $nginxstatloganswer01x05 $timestemp\n";
print "so_statlog.$hostname.nginx.statlog.answer.05x1 $nginxstatloganswer05x1 $timestemp\n";
print "so_statlog.$hostname.nginx.statlog.answer.1xinf $nginxstatloganswer1xinf $timestemp\n";
