#!/usr/bin/env python
#-*- coding: utf-8 -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os
import sys
import time
import signal
import string
import socket
from ConfigParser import ConfigParser, Error
from statistics import Statistics
from logdumper import LogDumper
from logreader import LogReader
from daemonize import become_daemon
from common import getHosts4Group
from logger import *
from tornado.locks import Lock
from tornado.ioloop import IOLoop
from tornado.httpclient import AsyncHTTPClient, HTTPRequest
from tornado.web import RequestHandler, Application
from tornado.httpserver import HTTPServer
from tornado.gen import coroutine, Task
from tornado.escape import url_escape, _unicode

DEBUG = False # True - run server in foreground, False - run it in background


def reload_config():
    global CFG

    config = ConfigParser()
    config.optionxform = str
    config.read(sys.argv[1])
    CFG = dict(config.items('common'))
    CFG.update({
        "logs":     dict(config.items('logs')),
        "dumper":   dict(config.items('dumper')),
        "reader":   dict(config.items('reader')),
        "rules_db": dict(config.items('rules_db'))
    })
    CFG["port"] = int(CFG["port"])
    CFG["processes"] = int(CFG["processes"])
    HOSTS = ["statlog{}.so.yandex.net".format(k) for k in ['1h', '1f', '1g', '1m', '1o', '1p', '01e', '02e', '03e', '01h', '02h', '01f', '02f']]
    #HOSTS = getHosts4Group(CFG["cluster"], HOSTS)
    localhost = socket.gethostname()
    CFG["servers"] = {
        "in":   ["{}:{}".format("127.0.0.1" if host == localhost else host, CFG["port_in"])   for host in HOSTS],
        "out":  ["{}:{}".format("127.0.0.1" if host == localhost else host, CFG["port_out"])  for host in HOSTS],
        "corp": ["{}:{}".format("127.0.0.1" if host == localhost else host, CFG["port_corp"]) for host in HOSTS]
    }
    CFG["dumper"]["queue_size"] = int(CFG["dumper"]["queue_size"])
    CFG["dumper"]["parsing_queue_size"] = int(CFG["dumper"]["parsing_queue_size"])
    CFG["dumper"]["parsing_queue_warning_size"] = int(CFG["dumper"]["parsing_queue_warning_size"])
    CFG["dumper"]["parsing_queue_batch_size"] = int(CFG["dumper"]["parsing_queue_batch_size"])
    CFG["dumper"]["indexers_concurrency"] = int(CFG["dumper"]["indexers_concurrency"])
    CFG["dumper"]["parsers_concurrency"] = int(CFG["dumper"]["parsers_concurrency"])
    CFG["dumper"]["send_time_period"] = int(CFG["dumper"]["send_time_period"])
    CFG["dumper"]["data_time_step"] = int(CFG["dumper"]["data_time_step"])
    CFG["reader"]["connect_timeout"] = float(CFG["reader"]["connect_timeout"]) / 1000
    CFG["reader"]["request_timeout"] = float(CFG["reader"]["request_timeout"]) / 1000
    CFG["rules_db"]["port"] = int(CFG["rules_db"]["port"])
    configure("statlog_%s" % CFG["sotype"])


def reload_config_wrapper():
    try:
        reload_config()
    except Error, e:
        print >> sys.stderr, "Error: cannot parse config file - ", e
        exit(1)


def write_pid(pidfile, pid):
    print >> open(pidfile, "wt"), pid


class PingHandler(RequestHandler):
    @coroutine
    def get(self):
        status = 200
        if hasattr(self.application, "check_lock") and hasattr(self.application, "check_status"):
            with (yield self.application.check_lock.acquire()):
                status = self.application.check_status
        self.write("")

    @coroutine
    def post(self):
        status = 200
        if hasattr(self.application, "check_lock") and hasattr(self.application, "check_status"):
            with (yield self.application.check_lock.acquire()):
                status = self.application.check_status
        self.write("")


class HostNameHandler(RequestHandler):
    @coroutine
    def get(self):
        self.write(socket.gethostname())

    @coroutine
    def post(self):
        self.write(socket.gethostname())


class CheckHandler(RequestHandler):
    def initialize(self, dumper):
        self.dumper = dumper
        setattr(self.application, "check_lock", Lock())
        self.check_status = 200

    @coroutine
    def get(self):
        statistics.add("check")
        mail = self.request.uri.split("mail=")[-1]
        self.dumper.add({"mail": mail})
        self.write("")

    @coroutine
    def post(self):
        statistics.add("check")
        mail, success = str(self.get_argument("mail", "")), False
        if mail:
            success = self.dumper.add({"mail": mail})
        else:   # we expect for JSON in body and some required CGI parameters
            data = {
                "json":       self.request.body,
                "ts":         int(self.get_query_argument("ts", "0")),
                "fromaddr":   self.get_query_argument("fromaddr", ""),
                "msgid":      self.get_query_argument("msgid", ""),
                "source_ip":  self.get_query_argument("source_ip", ""),
                "queueid":    self.get_query_argument("queueid", ""),
                "locl":       self.get_query_argument("locl", ""),
                "mx":         self.get_query_argument("mx", ""),
                "suid":       self.get_query_argument("suid", ""),
                "uid":        self.get_query_argument("uid", ""),
                "rcpts_uids": self.get_query_argument("rcpts_uids", ""),
                "code":       self.get_query_argument("code", "")
            }
            success = self.dumper.add(data)
        status = 200 if success else 509
        self.set_status(status)
        with (yield self.application.check_lock.acquire()):
            self.application.check_status = status
        self.write("")

    def decode_argument(self, value, name=None):
        """Decodes an argument from the request.

        The argument has been percent-decoded and is now a byte string.
        By default, this method decodes the argument as utf-8 and returns
        a unicode string, but this may be overridden in subclasses.

        This method is used as a filter for both `get_argument()` and for
        values extracted from the url and passed to `get()`/`post()`/etc.

        The name of the argument is provided if known, but may be None
        (e.g. for unnamed groups in the url regex).
        """
        try:
            return _unicode(value)
        except UnicodeDecodeError:
            try:
                return unicode(value, "utf8", "replace")
            except Exception, e:
                raise HTTPError(400, "Invalid unicode in %s: %r" % (name or "url", value))


class SearchHandler(RequestHandler):
    def initialize(self, reader):
        self.reader = reader

    @coroutine
    def get(self):
        statistics.add("search")
        log = ""
        try:
            qid = self.get_argument("qid", "")
            mid = self.get_argument("mid", "")
            if qid or mid:
                timestamp = int(self.get_argument("time", time.time()))
                log = yield self.reader.getByQid(qid, mid, int(timestamp))
        except Exception, e:
            statistics.add("search_err")
            error("Error in /search: %s" % str(e))
        self.write(log)


class SearchRangeHandler(RequestHandler):
    def initialize(self, reader):
        self.reader = reader

    @coroutine
    def get(self):
        statistics.add("searchrange")
        logs = ""
        try:
            timestamp = int(self.get_argument("time", time.time()))
            code = filter(len, self.get_argument("code", "").split(","))
            locl = self.get_argument("locl", "")
            qidmid = self.get_argument("qidmid", "")
            ip = self.get_argument("ip", "")
            uid = self.get_argument("uid", "")
            suid = self.get_argument("suid", "")
            limit = int( self.get_argument("limit", "20"))
            logs = yield self.reader.getRange(timestamp, code, locl, qidmid, ip, uid, suid, limit)
        except Exception, e:
            statistics.add("searchrange_err")
            error("Error in /searchrange: %s" % str(e))
        self.write(logs)


class SearchAllHandler(RequestHandler):
    def initialize(self):
        if not hasattr(SearchAllHandler, "http"):
            SearchAllHandler.http = AsyncHTTPClient(max_clients=128)

    @coroutine
    def get(self):
        statistics.add("searchall")
        log = ""
        try:
            qid = self.get_argument("qid", "")
            mid = self.get_argument("mid", "")
            if qid or mid:
                timestamp = self.get_argument("time", time.time())
                route = self.get_argument("route", "").lower()
                responses = []
                if route not in CFG["servers"]:
                    route = "in"
                for hostport in CFG["servers"][route]:
                    request = HTTPRequest("http://%s/search?qid=%s&mid=%s&time=%s" %
                            (hostport, url_escape(qid), url_escape(mid), url_escape(timestamp)),
                            connect_timeout=CFG["reader"]["connect_timeout"], request_timeout=CFG["reader"]["request_timeout"])
                    responses.append(SearchAllHandler.http.fetch(request))
                for i, response in enumerate(responses):
                    try:
                        answer = yield response
                        log = answer.buffer.read()
                        if log:
                            break
                    except Exception, e:
                        error("Reader exception while quering host(%s): %s" % (CFG["servers"][route][i], str(e)))
        except Exception, e:
            statistics.add("searchall_err")
            error("Error in /searchall: %s" % str(e))
        self.write(log)


class SearchAllRangeHandler(RequestHandler):
    def initialize(self):
        if not hasattr(SearchAllRangeHandler, "http"):
            SearchAllRangeHandler.http = AsyncHTTPClient(max_clients=128)

    @coroutine
    def get(self):
        statistics.add("searchallrange")
        logs = ""
        try:
            route = self.get_argument("route", "").lower()
            responses = []
            if route not in CFG["servers"]:
                route = "in"
            for hostport in CFG["servers"][route]:
                request = HTTPRequest("http://%s/searchrange?%s" % (hostport, self.request.query),
                        connect_timeout=CFG["reader"]["connect_timeout"], request_timeout=CFG["reader"]["request_timeout"])
                responses.append(SearchAllRangeHandler.http.fetch(request))
            for i, response in enumerate(responses):
                try:
                    answer = yield response
                    log = answer.buffer.read()
                    if log:
                        logs += log
                except Exception, e:
                    error("Reader exception while quering host(%s): %s" % (CFG["servers"][route][i], str(e)))
        except Exception, e:
            statistics.add("searchallrange_err")
            error("Error in /searchallrange: %s" % str(e))
        self.write(logs)


class SearchRangeNewHandler(RequestHandler):
    def initialize(self, reader):
        self.reader = reader

    @coroutine
    def get(self):
        statistics.add("searchrangenew")
        logs = ""
        try:
            time_constraint = int(self.get_argument("time", "0"))
            mintime = int(self.get_argument("mintime", "0"))
            maxtime = int(self.get_argument("maxtime", "0"))
            if not time_constraint:
                time_constraint = {}
                if mintime:
                    time_constraint["mintime"] = mintime
                if maxtime:
                    time_constraint["maxtime"] = maxtime
            code = filter(len, self.get_argument("code", "").split(","))
            locl = self.get_argument("locl", "")
            qidmid = self.get_argument("qidmid", "")
            ip = self.get_argument("ip", "" )
            uid = self.get_argument("uid", "")
            suid = self.get_argument("suid", "")
            rcpt_uid = self.get_argument("rcpt_uid", "")
            fromaddr = self.get_argument("fromaddr", "")
            limit = int(self.get_argument("limit", "20"))
            skip = int(self.get_argument("skip", "0"))
            routes = filter(len, self.get_argument("routes", "").split(','))
            logs = yield self.reader.getRangeEx(time_constraint, code, locl, qidmid, ip, uid, suid, rcpt_uid, fromaddr, routes, limit, skip)
        except Exception, e:
            statistics.add("searchrangenew_err")
            error("Error in /searchrangenew: %s" % str(e))
        self.write(logs)


class SearchJsonHandler(RequestHandler):
    def initialize(self, reader):
        self.reader = reader

    @coroutine
    def get(self):
        logs = ""
        try:
            offsets = map(int, filter(len, self.get_argument("offsets", "").split(",")))
            logs = yield self.reader.getJson(offsets)
        except Exception, e:
            error("Error in /searchjson: %s" % str(e))
        self.write(logs)

@coroutine
def release_files():
    while True:
        try:
            trace("releasing files")
            logreader.reload()
            yield Task(IOLoop.current().add_timeout, time.time() + 60)
        except Exception, e:
            error("release_files error: %s" % str(e))

def sigterm_handler(sig, frame):
    action("SIGTERM received: %d" % os.getpid())
    if os.getpid() == MAINPROCESS_PID:
        action("SIGTERM received")
        child_pids = os.popen("ps xao ppid,pid,cmd | grep -v ps | awk '$1 == %d { print $2 }'" % os.getpid()).read()
        for pid in child_pids.split():
            os.kill(int(pid), signal.SIGTERM)
    if DEBUG:
        os._exit(0)
    else:
        sys.exit()


reload_config_wrapper()

if not DEBUG:
    become_daemon()


signal.signal(signal.SIGTERM, sigterm_handler)
signal.signal(signal.SIGHUP, signal.SIG_IGN)
MAINPROCESS_PID = os.getpid()
write_pid(CFG["pidfile"], MAINPROCESS_PID)

statistics = Statistics()

logdumper = LogDumper(CFG["sotype"], CFG["dumper"], CFG["rules_db"])
logreader = LogReader(CFG["sotype"], CFG["dumper"]["path"])
application = Application(
    [ ( r"/ping", PingHandler ),
      ( r"/hostname", HostNameHandler ),
      ( r"/check", CheckHandler, { "dumper": logdumper } ),
      ( r"/search", SearchHandler, { "reader": logreader } ),
      ( r"/searchrange", SearchRangeHandler, { "reader": logreader } ),
      ( r"/searchall", SearchAllHandler ),
      ( r"/searchallrange", SearchAllRangeHandler ),
      ( r"/searchrangenew", SearchRangeNewHandler, { "reader": logreader } ),
      ( r"/searchjson", SearchJsonHandler, { "reader": logreader } ),
    ] )

server = HTTPServer(application)
server.bind(CFG["port"])
server.start(CFG["processes"])

action("http_qproxy v.2.0 on port %s started" % CFG["port"])
print "http_qproxy v.2.0 on port %s started" % CFG["port"]

statistics.install_buildstat()

IOLoop.current().add_callback(release_files)
IOLoop.current().start()
