#!/usr/bin/env python
#-*- coding: utf-8 -*-
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os
import sys
import re
import glob
import pymongo
from datetime import datetime

MONGO_DB = "solog"

def date_match(str_date, min_days):
    today = datetime.today().replace(hour=0, minute=0, second=0, microsecond=0)
    return (today - datetime.strptime(str_date, "%Y%m%d")).days > min_days

route = sys.argv[1].lower()
min_days = int(sys.argv[2])

mongoclient = pymongo.MongoClient()

for collection_name in mongoclient[MONGO_DB].collection_names():
    if not collection_name.startswith("so_%s" % route):
        continue
    match = re.search("(\d+)$", collection_name)
    if match and date_match(match.group(1), min_days):
        try:
            mongoclient[MONGO_DB][collection_name].drop()
            print "MongoDB collection", collection_name, "dropped"
        except Exception, e:
            print "Error while droping MongoDB collection: %s." % collection_name, "Error:", str(e)

for filename in glob.glob("/u0/statlog/so_%s/so_%s*.log" % (route, route)):
    match = re.search("(\d+)\.log$", filename)
    if match and date_match(match.group(1), min_days):
        try:
            os.remove(filename)
            print "File", filename, "deleted"
        except Exception, e:
            print >> sys.stderr, "Error while deleting file: %s." % filename, "Error:", str(e)
