#!/usr/bin/python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import sys, argparse
import yt.wrapper as ytw

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument('-t', '--tables',       nargs='*',             help = "YT tables to be deleted")
    parser.add_argument('-f', '--take_folders', action = 'store_true', help = "Whether it should delete folders, which contains these YT tables")
    args = parser.parse_known_args()[0]
    TABLES = args.tables if args.tables else []
    print >>sys.stderr, "Number of input tables/folders: %s" % len(TABLES)
    for table in TABLES:
        if args.take_folders:
             table = table[:table.rfind('/')]
        print >>sys.stderr, "Deleting table/folder: %s" % table
        ytw.remove(table, recursive = True, force = True)
