#!/usr/bin/python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, sys, argparse, json
from urllib import urlopen, quote
import nirvana.mr_job_context as nv
from traceback import format_exception

SAVE_MODEL_PARAMS_URL = "https://web.so.yandex-team.ru/ml/save_model_params/?"

def get_traceback():
    exc_type, exc_value, exc_traceback = sys.exc_info()
    tb = ''
    for step in format_exception(exc_type, exc_value, exc_traceback):
        try:
            tb += "\t" + step.strip() + "\n"
        except:
            pass
    return tb

def writelog(msg, isTB = False):
    if not msg: return
    try:
        tb = "\n"
        if isTB:
            tb = get_traceback()
        print >>sys.stderr, msg, tb
    except Exception, e:
        print >>sys.stderr, "Writelog error: %s" % str(e)

def doRequest(url, prompt):
    try:
        f = urlopen(url)
        if f.getcode() == 200:
            return f.read()
        else:
            print >>sys.stderr, '{0} response HTTP code: {1}, body: {2}'.format(prompt, f.getcode(), f.info())
    except Exception, e:
        writelog('%s HTTP request failed: %s.%s' % (prompt, str(e), get_traceback()))
    return ""

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument('-d', '--directory',      type = str, help = "Features' directory path in YT for MN model")
    parser.add_argument('-r', '--route',          type = str, help = "The type of mail for which the model is calculated")
    parser.add_argument('-t', '--eval_result',    type = str, help = "Path to features evaluation result in TSV format")
    parser.add_argument('-v', '--vw_resource_id', type = str, help = "Resource ID of VW model")
    parser.add_argument('-o', '--output_params',  type = str, help = "Output parameters of the catboost model in JSON-format: threshold, model type, F-measure and so on")
    args = parser.parse_known_args()[0]
    ROUTE = args.route if args.route else 'in'
    ctx = nv.context()
    meta = ctx.get_meta()
    workflow_url = meta.get_workflow_url()
    if workflow_url.endswith(meta.get_workflow_uid()):
        workflow_url += '/' + meta.get_workflow_instance_uid()
    OUTPUT_JSON = {
        "route":                ROUTE,
        "status":               "models_offline_test",
        "model_type":           "catboost",
        "threshold":            0,
        'workflow_id':          meta.get_workflow_uid(),
        'workflow_instance_id': meta.get_workflow_instance_uid(),
        'workflow_url':         workflow_url,
        'workflow_description': meta.get_description(),
        'rules_dict':           '%s/rules_full_dict' % args.directory
    }
    try:
        f = open(args.vw_resource_id)
        OUTPUT_JSON['vw_model_resource_id'] = f.read().strip()
        f.close()
    except Exception, e:
        writelog("Load VW model resource ID from local file error: %s" % str(e), True)
    try:
        f, i = open(args.eval_result), -1
        f.seek(-1024, 2)
        s = f.read(1024).rstrip()
        i = s.rfind('\n')
        while i < 0:
            f.seek(-2048, 1)
            s += f.read(1024)
            i = s.rfind('\n')
        if i >= 0:
            s = s[i + 1:]
        f.close()
        writelog("The last string of TSV-file: '%s'" % s)
        res = map(float, s.strip().split('\t'))
        OUTPUT_JSON.update({
            "f1_score":  res[1],
            "precision": res[2],
            "recall":    res[3],
            "accuracy":  res[4]
        })
    except Exception, e:
        writelog("Parsing of model's evaluation file failed: %s" % str(e), True)
    doRequest(SAVE_MODEL_PARAMS_URL + '&'.join(map(lambda it: "%s=%s" % (it[0], quote(str(it[1]))), OUTPUT_JSON.items())), 'Saving model\'s info')
    try:
        f = open(args.output_params, 'wt')
        print >>f, json.dumps(OUTPUT_JSON)
        f.close()
    except Exception, e:
        writelog('Saving result file error: %s' % str(e), True)
