#!/usr/bin/python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import sys, json, argparse, requests

SAVE_FORMULA_URL = "https://so-web.n.yandex-team.ru/ml/save_file/?file=%s"

def get_formula(formula_id, file_name):
    try:
        r = requests.get("https://fml.yandex-team.ru/download/computed/formula?id=%s&file=%s" % (formula_id, file_name))
        if r.status_code == 200:
            return r.content
        else:
            print >>sys.stderr, 'get_formula response HTTP Response Code: {status_code}, Body: {content}'.format(status_code = r.status_code, content = r.content)
    except requests.exceptions.RequestException, e:
        print >>sys.stderr, 'HTTP Request failed: %s' % str(e)
    return ""

def download_file(data, file_name):
    if data:
        try:
            r = requests.post(url = SAVE_FORMULA_URL % file_name, data = data)
            if r.status_code == 200:
                return r.content
            else:
                print >>sys.stderr, 'download_file response HTTP Response Code: {status_code}, Body: {content}'.format(status_code = r.status_code, content = r.content)
        except requests.exceptions.RequestException, e:
            print >>sys.stderr, 'HTTP Request failed: %s' % str(e)

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument('-f', '--formula', type = str, help = "Output formula after training")
    args, formula = parser.parse_known_args()[0], {}

    if args.formula:
        FORMULA_FILE = args.formula

    if not FORMULA_FILE:
        print >>sys.stderr, "Must be formula's file name specified!"
        sys.exit(1)
    try:
        f = open(FORMULA_FILE)
        formula = json.loads(f.read())
        f.close()
    except Exception, e:
        print >>sys.stderr, "Error: %s" % str(e)
    for f in ["matrixnet.info", "matrixnet.inc", "matrixnet.fstr"]:
        data = get_formula(formula["id"], f)
        download_file(data, f)
