#!/usr/bin/env python

import yt.wrapper as ytw
import sys, re, argparse, json
from urllib import urlopen
from traceback import format_exception

YT_LOG_DIR_1D = '//home/logfeller/logs/passport-log/1d'
YT_FRODO_DIFF = '//home/so_fml/KPI/Frodo/today_diff'
YT_FRODO_KPI = '//home/so_fml/KPI/Frodo/KPI'
URL_GET_LAST = 'https://web.so.yandex-team.ru/tools/frodo/getlastlog'
URL_SET_LAST = 'https://web.so.yandex-team.ru/tools/frodo/setlastlog'

def get_traceback():
    exc_type, exc_value, exc_traceback = sys.exc_info()
    tb = ''
    for step in format_exception(exc_type, exc_value, exc_traceback):
        try:
            tb += "\t" + step.strip() + "\n"
        except:
            pass
    return tb

def Error(s, isTB = False):
    if isTB:
        s += get_traceback()
    print >>sys.stderr, s

def mapper(record):
    def karma_transform(karma_o, karma_n = ""):
      def karma_t(karma):
        if karma == "0" or (karma.startswith("2") or karma.startswith("6")) and len(karma) == 4:
            return "h" #"ham"
        elif karma.startswith("1") and len(karma) in [3,4]:
            return "m" #"malic"
        elif karma == "80" or karma == "85" or karma.startswith("7") and len(karma) == 4:
            return "s" #"spam"
        else:
            return ""
      return karma_t(karma_o) + karma_t(karma_n)

    com =    ["p","n","fp","fn"]
    d = { "h": [ 0, 1, 0, 0],
          "s": [ 1, 0, 0, 0],
          "m": [ 1, 0, 0, 0],
          "hs":[ 0, 0, 0, 1],
          "hm":[ 0, 0, 0, 1],
          "sm":[-1, 1, 0, 1],
          "sh":[ 0, 0, 1, 0],
          "mh":[ 0, 0, 1, 0],
          "hh":[ 0, 0, 0, 0],
          "ss":[ 0, 0, 0, 0],
          "mm":[ 0, 0, 0, 0],
          "ms":[ 0, 0, 0, 0],
          "xh":[-1, 1, 0, 0],
          "xs":[ 1,-1, 0, 0],
          "xm":[ 1,-1, 0, 0]}
    res = {}
    consumers = ['sologger.mail.yandex.net', 'spdaemon']
    action = record.get("action", "")
    consumer = record.get("consumer", "")
    date_event = str(record.get("iso_eventtime", "0 0")).split()[0]
    date_reg   = str(record.get("registration_datetime", "0 0")).split()[0]
    if action == 'account_created':
        karma  = record.get("karma", "")
        if karma:
            res.update(dict(zip(com, d[karma_transform(karma)])))
            res.update({"date": date_event})
            yield res
    elif action == 'pending_karma_update':
        karma_n = record.get("new", "")
        karma_o  = record.get("old", "")
        res.update(dict(zip(com, d[ "x" + karma_transform(karma_n)])))
        res.update({"date": date_reg})
        yield res
    elif action in ['confirm_and_bind_secure','change_password','secure_bind_commit'] or action == 'karma' and consumer in consumers:
        karma_n = record.get("new", "")
        karma_o  = record.get("old", "")
        res.update(dict(zip(com, d[karma_transform(karma_o, karma_n)])))
        res.update({"date": date_reg})
        yield res
    elif record.get("consumer", "") == "meltingpot" and record.get("entity") == "password.is_changing_required":
        yield {"date": date_event, "chp": 1}
    else:
        pass

def reducer_diff(key, records):
    date = key.get("date", "")
    fp, tp, fn, fp, p, n = 0, 0, 0, 0, 0, 0
    chp = 0
    for r in records:
        p += r.get("p", 0)
        n += r.get("n", 0)
        fp += r.get("fp", 0)
        fn += r.get("fn", 0)
        chp += r.get("chp", 0)
    yield {"date": date, "fp": fp, "fn": fn, "p": p, "n": n, "chp": chp}

def reducer(key, records):
    date = key.get("date", "")
    fp, tp, fn, fp, p, n = 0, 0, 0, 0, 0, 0
    chp = 0
    for r in records:
        p += r.get("p", 0)
        n += r.get("n", 0)
        fp += r.get("fp", 0)
        fn += r.get("fn", 0)
        chp += r.get("chp", 0)
    tp = p - fp
    tn = n - fn
    if date > "2017-02-31":
        pr  = 1.0 * tp / (tp + fp + 1.0)
        rec = 1.0 * tp / (tp + fn + 1.0)
        f1  = 2.0 * pr * rec / (pr + rec)
        yield {"date": date, "f1": f1, "pr": pr, "rec": rec, "tp": tp, "tn": tn, "fp": fp, "fn": fn, "p": p, "n": n, "chp": chp}

if __name__ == "__main__":
    log_list = ()
    last_log = ""
    parser = argparse.ArgumentParser()
    parser.add_argument('-o', '--output', type = str, help = "Path to output json with data to upload to YaStat")
    args = parser.parse_known_args()[0]
    OUTPUT_JSON_FILE = args.output if args.output else './output_data.json'
    try:
        response = urlopen(URL_GET_LAST + "?log=frodo_kpi")
        if response.getcode() == 200:
            logfile = response.read()
            Error("Received last log date: %s" % logfile)
            if logfile.find('error') < 0:
                log_list = filter(lambda x: 1 if x > logfile else 0, ytw.cypress_commands.list(YT_LOG_DIR_1D))
                last_log = max(log_list + [logfile])
                log_list = map(lambda x: YT_LOG_DIR_1D + '/' + x, log_list)
            else:
                Error("GetLastLog value error (code=%s)" % response.getcode())
        else:
            Error("GetLastLog connection error!")
        response.close()
    except Exception, e:
        Error("GetLastLog failed: %s." % str(e), True)
    if not log_list:
        Error("Exiting...")
        sys.exit(1)
    try:
        response = urlopen(URL_SET_LAST + "?log=frodo_kpi&time={0}".format(last_log))
        if response.getcode() == 200 and response.read().strip() == "OK":
            ytw.run_map_reduce(mapper, reducer_diff, log_list, YT_FRODO_DIFF, reduce_by = ['date'])
            ytw.run_sort(YT_FRODO_DIFF, sort_by = ['date'])
        else:
            Error("Error while setting up last log's date (responce code = %s)" % response.getcode())
        ytw.run_sort(YT_FRODO_KPI, sort_by = ["date"])
        ytw.run_reduce(reducer, [YT_FRODO_DIFF, YT_FRODO_KPI], YT_FRODO_KPI, reduce_by = ["date"])
        ytw.run_sort(YT_FRODO_KPI, sort_by = ["date"])
        response.close()
    except Exception, e:
        Error("GetLastLog failed: %s." % str(e), True)
    data = []
    for r in ytw.read_table(YT_FRODO_KPI):
        data.append( {"fielddate": r.get("date", ""), "tp": r.get("tp", 0), "tn": r.get("tn", 0), "fp": r.get("fp", 0), "fn": r.get("fn", 0), "chp": r.get("chp", 0)} )
    try:
        f = open(OUTPUT_JSON_FILE, 'wt')
        print >>f, json.dumps(data)
        f.close()
    except Exeption, e:
        Error('Saving result JSON-file error: %s' % str(e), True)
