#!/usr/bin/python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import sys
import yt.wrapper as ytw
from urllib import urlopen
from traceback import format_exception

YT_LOG_PATH = '//home/logfeller/logs/passport-log/1d/2017-03-21'
YT_FRODO_OUT = '//home/so_fml/logparsers/frodo/passport_karma'
YT_LOG_DIR_30M = "//home/logfeller/logs/passport-log/30min"
URL_GET_LAST = 'https://web.so.yandex-team.ru/tools/frodo/getlastlog'
URL_SET_LAST = 'https://web.so.yandex-team.ru/tools/frodo/setlastlog'
URL_FRODO    = 'https://web.so.yandex-team.ru/tools/frodo/trail'
""" https://web.so.yandex-team.ru/frodo/trail?mail=restupil&malic=1&spam=-1&ham=0"""

def get_traceback():
    exc_type, exc_value, exc_traceback = sys.exc_info()
    tb = ''
    for step in format_exception(exc_type, exc_value, exc_traceback):
        try:
            tb += "\t" + step.strip() + "\n"
        except:
            pass
    return tb

def Error(s):
    print >> sys.stderr, s

def mapper(record):

    def karma_transform(karma):
        if karma == "0" or (karma.startswith("2") or karma.startswith("6")) and len(karma) == 4:
            return "ham"
        elif karma.startswith("1") and len(karma) in [3,4]:
            return "malic"
        elif karma == "80" or karma == "85" or karma.startswith("7") and len(karma) == 4:
            return "spam"
        else:
            return ""

    consumer = 'sologger.mail.yandex.net'
    action = ['karma', 'admkarma', 'confirm', 'change_password']
    destination = 'frodo'
    res = {}
    if record.get('action', '') in action and (not record.get('consumer', '') in ["-", "test"]):
        uid = record['uid']
        old_karma = karma_transform(record['old'])
        new_karma = karma_transform(record['new'])
        login = record['login']
        if old_karma != new_karma and old_karma and new_karma:
            yield { "uid": uid,
                    "old_karma": old_karma,
                    "new_karma": new_karma,
                    "login": login,
                    "consumer": record.get('consumer', ''),
                    "action": "karma" }

def reducer(key, records):
    for r in records:
        new_karma, old_karma = r["new_karma"], r["old_karma"]
        params = "?mail={0}&{1}=1&{2}=-1".format(r["login"], new_karma, old_karma)
        res = {"url": params, "res": r}
        yield res

def main():
    log_list, last_log, itworks, errors_count = [], "", False, 0
    try:
        try:
            response = urlopen(URL_GET_LAST + "?log=passport")
            if response.getcode() == 200:
                logfile = response.read()
                if logfile != "error":
                    for l in ytw.cypress_commands.list(YT_LOG_DIR_30M):
                        if l > logfile:
                            if l > last_log:
                                last_log = l
                            log_list.append(YT_LOG_DIR_30M + "/" + l)
                            itworks = True
                else:
                    Error("GetLastLog value error!")
            else:
                Error("GetLastLog connection error!")
            response.close()
        except Exception, e:
            Error("GetLastLog failed: %s.%s" % (str(e), get_traceback()))
        if not itworks:
            return 0
        try:
            response = urlopen(URL_SET_LAST + "?log=passport&time={0}".format(last_log))
            if log_list and response.read() == "200":
                ytw.run_map_reduce(mapper, reducer, log_list, YT_FRODO_OUT, reduce_by = ["action"])
            response.close()
        except Exception, e:
            Error("SetLastLog failed: %s.%s" % (str(e), get_traceback()))
        if ytw.cypress_commands.exists(YT_FRODO_OUT):
            n = 0
            for record in ytw.read_table(YT_FRODO_OUT, format = ytw.JsonFormat(), raw = False):
                url_args = record.get("url", "")
                if url_args:
                    n += 1
                    try:
                        r = urlopen(URL_FRODO + url_args)
                        errors_count = errors_count if r.read() == "200" else errors_count + 1
                        r.close()
                    except Exception, e:
                        Error("Frodo trail call failed: %s.%s" % (str(e), get_traceback()))
                if n % 100 == 0:
                    print n
            ytw.cypress_commands.remove(YT_FRODO_OUT + ".done")
            ytw.cypress_commands.move(YT_FRODO_OUT, YT_FRODO_OUT + ".done")
            print "Errors count: {0}".format(errors_count)
    except Exception, e:
        Error("YT operation failed: %s.%s" % (str(e), get_traceback()))

if __name__ == "__main__":
    main()
