#!/usr/bin/python2
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import sys, argparse
import yt.wrapper as ytw
import nirvana.mr_job_context as nv
from urllib import urlopen

SAVE_MODEL_STATUS_URL = "https://so-web.n.yandex-team.ru/ml/save_model_status/?workflow_id=%s&workflow_instance_id=%s&status=models_learning&route=%s"

def doRequest(url, prompt):
    try:
        f = urlopen(url)
        if f.getcode() == 200:
            return f.read()
        else:
            print >>sys.stderr, '{0} response HTTP code: {1}, body: {2}'.format(prompt, f.getcode(), f.info())
    except Exception, e:
        print >>sys.stderr, '%s HTTP request failed: %s' % (prompt, str(e))
    return ""

if __name__ == "__main__":
    YT_FEATURES_PATH = YT_RULES_DICT_PATH = YT_FREATURES_FOLDER = ""
    parser = argparse.ArgumentParser()
    parser.add_argument('-f', '--features',      type = str, help = "input YT table with features for training in FML")
    parser.add_argument('-d', '--rules_dict',    type = str, help = "input YT table with rules dictionary")
    parser.add_argument('-o', '--output_folder', type = str, help = "output YT directory with files to upload to FML")
    parser.add_argument('-r', '--route',         type = str, help = "The type of mail for which the model is calculated")
    args = parser.parse_known_args()[0]
    if args.features:
        YT_FEATURES_PATH = args.features
    else:
        print >>sys.stderr, "Input YT table with features must be set!"
    if args.rules_dict:
        YT_RULES_DICT_PATH = args.rules_dict
    else:
        print >>sys.stderr, "Input YT table with factor names must be set!"
    if args.output_folder:
        YT_FREATURES_FOLDER = args.output_folder
    else:
        print >>sys.stderr, "Output YT table with files for uploading to FML must be set!"
    ROUTE = args.route if args.route else 'in'
    try:
        ytw.copy(YT_FEATURES_PATH, YT_FREATURES_FOLDER + '/features', force = True)
    except Exception, e:
        print >>sys.stderr, "YT Move failed: %s" % str(e)
    factor_names = [{'key': '0', 'value': 'X_X_X'}]
    for r in ytw.read_table(YT_RULES_DICT_PATH, format = ytw.JsonFormat(), raw = False):
        if r['act']:
            factor_names.append({'key': str(r['num']), 'value': r['rule']})
    YT_FACTOR_NAMES_PATH = YT_FREATURES_FOLDER + '/factor_names'
    if ytw.exists(YT_FACTOR_NAMES_PATH):
        ytw.remove(YT_FACTOR_NAMES_PATH)
    ytw.write_table(YT_FACTOR_NAMES_PATH, factor_names, format = ytw.YsonFormat(), raw = False)
    ytw.copy(YT_RULES_DICT_PATH, YT_FREATURES_FOLDER + '/rules_full_dict', force = True)
    ctx = nv.context()
    meta = ctx.get_meta()
    doRequest(SAVE_MODEL_STATUS_URL % (meta.get_workflow_uid(), meta.get_workflow_instance_uid(), ROUTE), 'Saving model status')
