#!/usr/bin/python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys, argparse, urllib2, json, tarfile, time
from urllib import urlretrieve
from traceback import format_exception

RETRY_COUNT = 3
NIRVANA_API_HOST = 'https://nirvana.yandex-team.ru'
OAUTH_TOKEN = ""
WORKFLOW_ID = ""
WORKFLOW_INSTANCE_ID = ""
VW_CUR_MODEL_URL = "https://so-web.n.yandex-team.ru/ml/get_current_vw_model"
VW_CUR_MODEL_PATH = "./vw.bin"
VW_NEW_MODEL_PATH = "./vw_test.bin"
VW_TARBALL_PATH = "./vw.tar.gz"

def get_traceback():
    exc_type, exc_value, exc_traceback = sys.exc_info()
    tb = ''
    for step in format_exception(exc_type, exc_value, exc_traceback):
        try:
            tb += "\t" + step.strip() + "\n"
        except:
            pass
    return tb

def log(msg, isTB = False):
    if not msg: return
    try:
        tb = ""
        if isTB:
            tb = get_traceback()
        print >>sys.stderr, "[%s] %s" % (time.strftime("%Y-%m-%d %H:%M:%S"), msg + tb); sys.stderr.flush()
    except Exception, e:
        print >>sys.stderr, "Exception: %s" % str(e)

def requestNirvana(method, params, token):
    for i in range(RETRY_COUNT):
        try:
            r = urllib2.Request(url = '%s/api/public/v1/%s' % (NIRVANA_API_HOST, method),
                data = json.dumps({"jsonrpc": "2.0", "method": method, "id": params['workflowId'], "params": params}),
                headers = {'Content-Type': 'application/json; charset=utf-8', 'Authorization': 'OAuth %s' % token})
            f = urllib2.urlopen(r)
            if f:
                return f.read()
            else:
                log('requestNirvana request (attempt #%d) response is empty!' % (i + 1))
                continue
        except urllib2.URLError, e:
            log('requestNirvana HTTP request (attempt #%d) failed: %s\n' % (i + 1, e.reason), True)
            continue
        except urllib2.HTTPError, e:
            log('requestNirvana HTTP request (attempt #%d) failed (code=%s): %s\n' % (i + 1, e.code, e.reason), True)
            continue
        except Exception, e:
            log('requestNirvana HTTP request (attempt #%d) exception: %s\n' % (i + 1, str(e)), True)
            continue
    return ""

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument('-u', '--url',                  type = str, help = "URL for obtaining current VW model")
    parser.add_argument('-w', '--workflow_id',          type = str, help = "workflow ID where new VW model has been calculated")
    parser.add_argument('-i', '--workflow_instance_id', type = str, help = "workflow instance ID where new VW model has been calculated")
    parser.add_argument('-s', '--application_token',    type = str, help = "robot-mailspam application token")
    parser.add_argument('-o', '--output',               type = str, help = "output tarball with 2 models: current ant new/test")
    args, data = parser.parse_known_args()[0], {'result': []}
    if args.url:
        VW_CUR_MODEL_URL = args.url
    if args.workflow_id:
        WORKFLOW_ID = args.workflow_id
    if args.workflow_instance_id:
        WORKFLOW_INSTANCE_ID = args.workflow_instance_id
    if args.application_token:
        OAUTH_TOKEN = args.application_token
    if args.output:
        VW_TARBALL_PATH = args.output
    try:
        res = urlretrieve(VW_CUR_MODEL_URL, VW_CUR_MODEL_PATH)
    except Exception, e:
        print >>sys.stderr, 'HTTP request failed: %s' % str(e)
    log("CurModelFileSize: %s, DownloadResult: %s" % (os.stat(VW_CUR_MODEL_PATH).st_size, str(res)))
    if WORKFLOW_ID:
        params = {'workflowId': WORKFLOW_ID, 'blocks': [{'code': 'operation-1509717470951-227'}]}
        if WORKFLOW_INSTANCE_ID:
            params['workflowInstanceId'] = WORKFLOW_INSTANCE_ID
        data = json.loads(requestNirvana('getBlockResults', params, OAUTH_TOKEN))
        if 'error' in data:
            log('getSettings error: code=%s, message="%s", data="%s"' % (data['error']['code'], data['error']['message'], data['error']['data'] if 'data' in data['error'] else ''))
            exit(1)
    log("Data: %s" % json.dumps(data))
    if len(data['result']) > 0:
        for block in data['result']:
            for result in block['results']:
                log("Result: %s" % str(result))
                try:
                    if 'storagePath' in result and result['storagePath']:
                        result_data = ''
                        try:
                            f = urllib2.urlopen(urllib2.Request(url = result['storagePath'], headers = {'Content-Type': 'application/json; charset=utf-8'}))
                            if f:
                                if f.getcode() == 200:
                                    result_data = f.read()
                                else:
                                    log('Error retrieving Nirvana operation result by storagePath: code: %s, info: %s' % (f.getcode(), f.info()))
                            else:
                                log('Storage data is empty for operation block "%s" !' % block['blockCode'])
                        except Exception, e:
                            log('Resource in storagePath HTTP request failed: %s.' % str(e), True)
                        if result_data:
                            try:
                                with open(VW_NEW_MODEL_PATH, 'wb') as f_out:
                                    f_out.write(result_data)
                            except Exception, e:
                                log("Writing to file %s error: %s" % (VW_NEW_MODEL_PATH, str(e)), True)
                        else:
                            log("Zero binary data length error!")
                    else:
                        log("Error: Unable to find 'storagePath' key in Nirvana request data result: %s !" % result)
                except Exception, e:
                    log("Error '%s' for block: %s." % (str(e), result), True)
    else:
        try:
            with open(VW_CUR_MODEL_PATH, 'rb') as f_in:
                with open(VW_NEW_MODEL_PATH, 'wb') as f_out:
                    f_out.write(f_in.read())
        except Exception, e:
            log("Copying file %s error: %s" % (VW_CUR_MODEL_PATH, str(e)), True)
    with tarfile.open(VW_TARBALL_PATH, 'w:gz') as f:
        for file_path in [VW_CUR_MODEL_PATH, VW_NEW_MODEL_PATH]:
            f.add(file_path)
    log("List of files: %s" % str(os.listdir('./')))
