#!/usr/bin/env python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR/so-plotnik-ui')
import psycopg2
from time import time
from traceback import format_exception
from datetime import datetime, timedelta
from plotnik_common import *

def get_table(metric):
    parts = metric.split(".")
    if len(parts) < 4:
        return 'graph', ''
    else:
        db_type = parts[2].lower()
        return "graph_%ss" % db_type, db_type

def get_timestamp_range(starttime, endtime, follow, graph_points, min_period):
    if follow:
        endtime = int(time())
    if min_period == 604800:
        date_start = get_weekstart(starttime)
        date_end = get_weekstart(endtime)
        for days in xrange((date_end - date_start).days + 1):
            yield (date_start + timedelta(days = days))
    elif min_period == 86400:
        date_start = datetime.fromtimestamp(starttime).replace(hour = 0, minute = 0, second = 0, microsecond = 0)
        date_end = datetime.fromtimestamp(endtime).replace(hour = 0, minute = 0, second = 0, microsecond = 0)
        for days in xrange((date_end - date_start).days + 1):
            yield (date_start + timedelta(days = days))
    else:
        coeff = max(min_period, int((endtime - starttime) / graph_points))
        for timestamp in xrange(int(starttime / coeff) * coeff, endtime + 1, coeff):
            yield datetime.fromtimestamp(timestamp)

def get_graph_data(metric, graph):
    metric = metric.lower()
    graph['table'], graph['field'] = get_table(metric)
    graph['parameter'] = metric.split(".")[-1].upper()
    if 'follow' not in graph or graph['follow']:
        graph['endtime'] = int(time())
    graph['min_period'] = max(graph['min_period'], 180)
    if graph['endtime'] - graph['starttime'] <= 2 * graph['min_period']:
        graph['starttime'] -= graph['min_period']
        graph['endtime'] += graph['min_period']
    coeff = max(graph['min_period'], int((graph['endtime'] - graph['starttime']) / graph['graph_points']))
    data_db = {}
    try:
        db = getPGdb(PG_FRODO)
        cursor = db.cursor()
        if graph['min_period'] == 86400:
            graph['groupby'] = "EXTRACT(EPOCH FROM DATE_TRUNC('DAY', TO_TIMESTAMP(ts)))"
        elif graph['min_period'] == 604800:
            graph['groupby'] = "ts - interval (EXTRACT(DOW FROM ts) - 2)"
        elif graph['min_period'] == 2592000:
            graph['groupby'] = "EXTRACT(EPOCH FROM DATE_TRUNC('MONTH', TO_TIMESTAMP(ts)))"
        else:
            graph['groupby'] = "(floor(ts / {0}) * {0})".format(coeff)
        if graph['field']:
            query = """SELECT %(groupby)s AS tsd, %(aggregation)s(cnt) FROM %(table)s g LEFT JOIN %(field)ss t ON g.%(field)s_id = t.id
                    WHERE ts >= %(starttime)s AND ts <= %(endtime)s AND t.%(field)s = '%(parameter)s' GROUP BY tsd ORDER BY tsd""" % graph
        else:
            query = """SELECT %(groupby)s AS tsd, %(aggregation)s(%(parameter)s) FROM %(table)s
                    WHERE ts >= %(starttime)s AND ts <= %(endtime)s GROUP BY tsd ORDER BY tsd""" % graph
        writelog("PlotnikDB frodo query: %s" % query)
        cursor.execute(query)
        for rec in cursor:
            data_db[str(int(rec[0]))] = float(rec[1])
        #writelog("DB Data: %s" % data_db)
    except psycopg2.DatabaseError, e:
        if cursor and not cursor.closed:
            cursor.close()
        if e.pgcode != '42P01': # undefined_table
            writelog("PGaaS exception: %s" % str(e), True)
            raise
    else:
        if cursor and not cursor.closed:
            cursor.close()
    data = {}
    for dt in get_timestamp_range(graph['starttime'], graph['endtime'], graph['follow'], graph['graph_points'], graph['min_period']):
        ts = str(int(dt.strftime("%s")))
        if ts in data_db:
            data[datetime.fromtimestamp(int(ts))] = data_db[ts]
        elif ts not in data_db and graph['zerofill']:
            data[datetime.fromtimestamp(int(ts))] = 0
    #writelog("Data: %s" % data)
    return data

if __name__ == "__main__":
    getPGCredentials(PG_FRODO)
    print int(datetime(2017, 07, 13).strftime("%s"))
    print get_graph_data("so.frodostat.regtypes.ALTERNATIVEPHONE", int(datetime(2017, 07, 12).strftime("%s")), int(datetime(2017, 07, 14).strftime("%s")), False, 500)
