#!/usr/bin/env python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR/so-plotnik-ui')
from random import random
from time import time, mktime
from datetime import datetime, timedelta
from plotnik_common import *

MIN_PERIOD = 600

def get_timestamp_range(starttime, endtime, follow, graph_points, min_period):
    if follow:
        endtime = int(time())
    if min_period == 604800:
        date_start = get_weekstart(starttime)
        date_end = get_weekstart(endtime)
        for days in xrange((date_end - date_start).days + 1):
            yield (date_start + timedelta(days = days))
    elif min_period == 86400:
        date_start = datetime.fromtimestamp(starttime).replace(hour = 0, minute = 0, second = 0, microsecond = 0)
        date_end = datetime.fromtimestamp(endtime).replace(hour = 0, minute = 0, second = 0, microsecond = 0)
        for days in xrange((date_end - date_start).days + 1):
            yield (date_start + timedelta(days = days))
    else:
        coeff = max(min_period, int((endtime - starttime) / graph_points))
        for timestamp in xrange(int(starttime / coeff) * coeff, endtime + 1, coeff):
            yield datetime.fromtimestamp(timestamp)

def get_graph_data(metric, graph):
    min_period = max(graph['min_period'], MIN_PERIOD)
    metric_value = get_metric_value(metric)
    parameter = get_metric_parameter(metric).lower()
    cmpltype = (parameter[5:] if parameter.startswith('cmpl_') else parameter).replace('_', '')
    if 'follow' not in graph or graph['follow']:
        graph['endtime'] = int(time())
    data = {}
    try:
        db = redis_reconnect(REDIS_STAT)
        for dt in get_timestamp_range(graph['starttime'], graph['endtime'], graph['follow'], graph['graph_points'], min_period):
            ts = int(mktime(dt.timetuple()))
            key = "{0}_{1}_{2}".format(ts, cmpltype, metric_value)
            if min_period == 604800 or min_period == 86400:
                key_tmp = "{0}_{1}_{2}_tmp".format(key, int(time()), int(random() * 100000))
                db.zunionstore(key_tmp, map(lambda i: "{0}_{1}_{2}".format(ts + i * MIN_PERIOD, cmpltype, metric_value), range(min_period // MIN_PERIOD)))
                data[dt] = db.zcard(key_tmp)
                db.delete(key_tmp)
            else:
                if db.exists(key):
                    data[dt] = db.zcard(key)
                elif graph['zerofill']:
                    data[dt] = 0
    except Exception, e:
        writelog("Redis DB exception: %s" % str(e), True)
    return data

if __name__ == "__main__":
    print get_graph_data("so.mnrules.MN_AREA_ALL.in.uniq.cmpl_spam", {
        'starttime':    int(datetime(2019, 06, 18).strftime("%s")),
        'endtime':      int(datetime(2019, 06, 25).strftime("%s")),
        'zerofill':     False,
        'graph_points': 500
    })
