#!/usr/bin/env python
# encoding: utf-8
# kate: space-indent on; indent-width 4; replace-tabs on;
#
import os, os.path, sys
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, 'WORKING_DIR/so-plotnik-ui')
from time import time
from datetime import datetime, timedelta
from plotnik_common import *

def get_table(metric):
    return "Rules_%s" % (metric.split(".")[3].capitalize())

def get_timestamp_range(starttime, endtime, follow, graph_points, min_period):
    if follow:
        endtime = int(time())
    if min_period == 86400:
        date_start = datetime.fromtimestamp(starttime).replace(hour = 0, minute = 0, second = 0, microsecond = 0)
        date_end = datetime.fromtimestamp(endtime).replace(hour = 0, minute = 0, second = 0, microsecond = 0)
        for days in xrange((date_end - date_start).days + 1):
            yield (date_start + timedelta(days = days))
    else:
        coeff = max(min_period, int((endtime - starttime) / graph_points))
        for timestamp in xrange(int(starttime / coeff) * coeff, endtime + 1, coeff):
            yield datetime.fromtimestamp(timestamp)

def get_graph_data(metric, graph):
    metric = metric.lower()
    table = get_table(metric)
    metric_value = get_metric_value(metric)
    parameter = get_metric_parameter(metric)
    if 'follow' not in graph or graph['follow']:
        graph['endtime'] = int(time())
    fields = get_table_fields(table, graph['aggregation'])
    startdate = datetime.fromtimestamp(graph['starttime']).strftime("%Y-%m-%d")
    enddate = datetime.fromtimestamp(graph['endtime']).strftime("%Y-%m-%d")
    data_db = {}
    try:
        db = getMongoDB(MONGO_RULES)
        for obj in db[table].find({"date": {"$gte": startdate, "$lte": enddate}, "rule": metric_value}):
            data_db[datetime.strptime(obj["date"], "%Y-%m-%d")] = map(lambda field: int(obj.get(field, 0)), fields)
    except Exception, e:
        writelog("Rules MaaS exception: %s" % str(e), True)
    data = {}
    for dt in get_timestamp_range(graph['starttime'], graph['endtime'], graph['follow'], graph['graph_points'], 86400):
        if dt in data_db:
            data[dt] = getField(table, data_db[dt], parameter)
        elif dt not in data_db and graph['zerofill']:
            data[dt] = 0
    return data

if __name__ == "__main__":
    loadMongoDbCredentials(MONGO_RULES)
    print int(datetime(2015, 03, 03).strftime("%s"))
    print get_graph_data("so.rulesnew.MESS_SIZE_500K.in.hamall", int(datetime(2015, 03, 03).strftime("%s")),
            int(datetime(2015, 03, 13).strftime("%s")), False, 500)
