#!/bin/bash

PID_FILE=/var/run/get-csa-zone.pid
RBL_DIR=/var/lib/rbl

# sleep for async
sleep $((RANDOM%30))

if [ -s $PID_FILE ] ; then
    kill -9 `cat $PID_FILE`
fi

echo $$ > $PID_FILE
echo "$(date +'[%Y-%m-%d %H:%M]') Import CSA zones starts..."
/usr/bin/rsync -tz --password-file /etc/csa.txt yandex@remulus.csa.eco.de::whitelist/csa-whitelist.xml /var/tmp/
CSA_WL_DOWNLOAD_SUCCESS=$?
if [ "$CSA_WL_DOWNLOAD_SUCCESS" -eq 0 ]; then
    grep -Po '(?<=<IP>).+(?=</IP>)' /var/tmp/csa-whitelist.xml > /var/tmp/csa-whitelist.rbl
    /bin/sed -i '1 i :127.0.0.2:IP address $ is listed' /var/tmp/csa-whitelist.rbl
    if [ "$?" -eq 0 ]; then
        CSA_WL_CHANGED=$(diff /var/tmp/csa-whitelist.rbl ${RBL_DIR}/csa-whitelist.rbl | wc -l)
        cp -f /var/tmp/csa-whitelist.rbl ${RBL_DIR}/csa-whitelist.rbl
        echo -n "$(date +'[%Y-%m-%d %H:%M]') Uploading of csa-whitelist.rbl zones to SandBox "
        if [ "$CSA_WL_CHANGED" -gt 0 ]; then
            now=$(date +%s)
            if /opt/rbl/sandbox-upload.sh -t SO_RBL_CSA_WHITELIST -u robot-mailspam -d csa-whitelist-$now -A 'ttl=inf' -a any ${RBL_DIR}/csa-whitelist.rbl
            then
                taskid=$(curl -s 'https://sandbox.yandex-team.ru/api/v1.0/resource?type=SO_RBL_CSA_WHITELIST&limit=1&state=READY'|jq '.items[0].task.id')
                if [ $taskid != "null" ]
                then
                    if curl -s -H 'Content-Type: application/json; charset=utf-8' --data-binary '{"cc":["dpotapov@yandex-team.ru"],"task_id":'$taskid',"type":"stable","subject":"Release csa whitelist '$now'"}' 'https://sandbox.yandex-team.ru/api/v1.0/release'
                    then
                        echo "DONE"
                    else
                        echo "RELEASE FAILED"
                    fi
		else
                    echo "FAILED TO RESOLVE TASK ID"
		fi
            else
                echo "UPLOAD FAILED"
            fi
        else
            echo "SKIPPED"
        fi
    fi
    echo "$(date +'[%Y-%m-%d %H:%M]') Import CSA zones DONE"
else
    echo "$(date +'[%Y-%m-%d %H:%M]') Import CSA zones FAILED"
fi
rm -f $PID_FILE
