#!/bin/bash

PID_FILE=/var/run/import-rbl-zones.pid
RBL_DIR=/var/lib/rbl

if [ -s $PID_FILE ] ; then
    kill -9 `cat $PID_FILE`
fi

echo $$ > $PID_FILE
echo "$(date +'[%Y-%m-%d %H:%M]') Import RBL zones starts..."
/usr/bin/rsync -tzq blacksync.prolocation.net::surbl/multi.surbl.org.rbldnsd ${RBL_DIR} 2>/dev/null
/usr/bin/rsync -tzq blacksync.prolocation.net::surbl/surbl.org.acl ${RBL_DIR} 2>/dev/null
/usr/bin/rsync -tzq rsync.returnpath.net::cert_ru/cert.wl.ru.rpzones.com ${RBL_DIR}/returnpath-certifiedwhite && /bin/sed -i '/CKSUM/d' ${RBL_DIR}/returnpath-certifiedwhite 2>/dev/null
/usr/bin/rsync -tzq rsync.returnpath.net::ss-scores/bl.score.senderscore.com ${RBL_DIR}/returnpath-certifiedblack && /bin/sed -i '/CKSUM/d' ${RBL_DIR}/returnpath-certifiedblack 2>/dev/null
/usr/bin/rsync --timeout=30 -T ${RBL_DIR} -e "/usr/bin/ssh -i /etc/spamcop.key" -L bl@sauron.julianhaight.com:bl.data /var/tmp/rbldns.spamcop.yandex.ru
SPAMCOP_DOWNLOAD_SUCCESS=$?
if [ "$SPAMCOP_DOWNLOAD_SUCCESS" -eq 0 ]; then
    /bin/sed -i 's/:127.0.0.2/:127.0.0.4/1' /var/tmp/rbldns.spamcop.yandex.ru
    if [ "$?" -eq 0 ]; then
        SPAMCOP_CHANGED=$(diff /var/tmp/rbldns.spamcop.yandex.ru ${RBL_DIR}/rbldns.spamcop.yandex.ru | wc -l)
        cp -f /var/tmp/rbldns.spamcop.yandex.ru ${RBL_DIR}/rbldns.spamcop.yandex.ru
        echo -n "$(date +'[%Y-%m-%d %H:%M]') Uploading of rbldns.spamcop.yandex.ru zones to SandBox "
        if [ "$SPAMCOP_CHANGED" -gt 0 ]; then
            now=$(date +%s)
            if /opt/rbl/sandbox-upload.sh -t SO_RBL_SPAMCOP -u robot-mailspam -d rbldns.spamcop.yandex.ru-$now -A 'ttl=inf' -a any ${RBL_DIR}/rbldns.spamcop.yandex.ru
            then
                taskid=$(curl -s 'https://sandbox.yandex-team.ru/api/v1.0/resource?type=SO_RBL_SPAMCOP&limit=1&state=READY'|jq '.items[0].task.id')
                if [ $taskid != "null" ]
                then
                    if curl -s -H 'Content-Type: application/json; charset=utf-8' --data-binary '{"cc":["dpotapov@yandex-team.ru"],"task_id":'$taskid',"type":"stable","subject":"Release spamcop list '$now'"}' 'https://sandbox.yandex-team.ru/api/v1.0/release'
                    then
                        echo "DONE"
                    else
                        echo "RELEASE FAILED"
                    fi
		else
                    echo "FAILED TO RESOLVE TASK ID"
		fi
            else
                echo "UPLOAD FAILED"
            fi
        else
            echo "SKIPPED"
        fi
    fi
    echo "$(date +'[%Y-%m-%d %H:%M]') Import RBL zones DONE"
else
    echo "$(date +'[%Y-%m-%d %H:%M]') Import RBL zones FAILED"
fi
rm -f $PID_FILE
