#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/common/env.h>
#include <mail/so/spamstop/sp/rulesholder.h>
#include <mail/so/libs/lua_rules/dummy_context.h>

Y_UNIT_TEST_SUITE(TestRules) {
    static const TFsPath HS_CACHE = JoinFsPaths(GetWorkPath(), "hs_cache");
    Y_UNIT_TEST(IN_RULES) {
        TSpLoggers loggers;

        TRulesHolder rulesHolder(false,
                                 {
                                     JoinFsPaths(ArcadiaSourceRoot(), "mail/so/spamstop/rules/in"),
                                     JoinFsPaths(ArcadiaSourceRoot(), "mail/so/spamstop/rules/common"),
                                 },
                                 loggers,
                                 NRegexp::TSettings{},
                                 HS_CACHE,
                                 Nothing());
    }

    Y_UNIT_TEST(OUT_RULES) {
        TSpLoggers loggers;

        TRulesHolder rulesHolder(false,
                                {
                                    JoinFsPaths(ArcadiaSourceRoot(), "mail/so/spamstop/rules/outgoing"),
                                    JoinFsPaths(ArcadiaSourceRoot(), "mail/so/spamstop/rules/common"),
                                },
                                loggers,
                                NRegexp::TSettings{},
                                HS_CACHE,
                                Nothing());
    }

    Y_UNIT_TEST(CORP_RULES) {
        TSpLoggers loggers;

        TRulesHolder rulesHolder(false,
                                 {
                                     JoinFsPaths(ArcadiaSourceRoot(), "mail/so/spamstop/rules/local"),
                                     JoinFsPaths(ArcadiaSourceRoot(), "mail/so/spamstop/rules/common"),
                                     JoinFsPaths(ArcadiaSourceRoot(), "mail/so/spamstop/rules/in"),
                                 },
                                 loggers,
                                 NRegexp::TSettings{},
                                 HS_CACHE,
                                 Nothing());
    }

    Y_UNIT_TEST(CHECKFORM) {
        TSpLoggers loggers;

        TRulesHolder rulesHolder(true,
                                 {
                                     JoinFsPaths(ArcadiaSourceRoot(), "mail/so/spamstop/rules/checkform"),
                                 },
                                 loggers,
                                 NRegexp::TSettings{},
                                 HS_CACHE,
                                 Nothing());
    }

    Y_UNIT_TEST(PASSPORT) {
        TSpLoggers loggers;

        TRulesHolder rulesHolder(true,
                                 {
                                     JoinFsPaths(ArcadiaSourceRoot(), "mail/so/spamstop/rules/passport"),
                                 },
                                 loggers,
                                 NRegexp::TSettings{},
                                 HS_CACHE,
                                 Nothing());
    }

    Y_UNIT_TEST(CHECKMESSAGES) {
        TSpLoggers loggers;

        TRulesHolder rulesHolder(true,
                                 {
                                     JoinFsPaths(ArcadiaSourceRoot(), "mail/so/spamstop/rules/checkmessages"),
                                 },
                                 loggers,
                                 NRegexp::TSettings{},
                                 HS_CACHE,
                                 Nothing());
    }

    Y_UNIT_TEST(MSEARCH) {
        TSpLoggers loggers;

        TRulesHolder rulesHolder(true,
                                 {
                                     JoinFsPaths(ArcadiaSourceRoot(), "mail/so/spamstop/rules/msearch"),
                                 },
                                 loggers,
                                 NRegexp::TSettings{},
                                 HS_CACHE,
                                 Nothing());
    }

    Y_UNIT_TEST(BadWords) {
        constexpr const auto YABACK_BAD_WORDS_ON_INIT_FUNCTION = "YABACK_BAD_WORDS_ON_INIT";
        constexpr const auto YABACK_BAD_WORDS_ON_INIT_RULE = "YABACK_HAS_BAD_WORDS_ON_INIT";
        constexpr const auto YABACK_BAD_WORDS_ON_INIT_SHINGLE = "YABACK_HAS_BAD_WORDS_ON_INIT";

        NLua::TRunner runner;
        runner.Load(JoinFsPaths(ArcadiaSourceRoot(), "mail/so/spamstop/rules/common/bad_words.lua"));
        UNIT_ASSERT(runner.FunctionExists(YABACK_BAD_WORDS_ON_INIT_FUNCTION));

        {
            const NHtmlSanMisc::TAnswer answer = [](){
                TFileInput stream(SRC_("bad-words-so-response.json"));
                return NHtmlSanMisc::TAnswer::Parse(NJson::ReadJsonTree(&stream, true));
            }();

            NRulesDummyContext::TContext context(answer);

            runner.Run(context.AsPtr(), YABACK_BAD_WORDS_ON_INIT_FUNCTION);


            UNIT_ASSERT_NO_EXCEPTION(context.GetRuleProvider().Get(YABACK_BAD_WORDS_ON_INIT_RULE));
            UNIT_ASSERT(context.GetRuleProvider().Get(YABACK_BAD_WORDS_ON_INIT_RULE).IsActive());
            UNIT_ASSERT(context.GetShingler().Get(68).contains(YABACK_BAD_WORDS_ON_INIT_SHINGLE));
        }
        {
            const NHtmlSanMisc::TAnswer answer = [](){
                TFileInput stream(SRC_("bad-words-so-response.json"));
                NJson::TJsonValue v = NJson::ReadJsonTree(&stream, true);
                v["hbf_project_id"] = "4120";
                v["docs"].GetArraySafe().front().InsertValue("hdr_from_normalized", "robot-atushka@yandex-team.ru\n");
                return NHtmlSanMisc::TAnswer::Parse(v);
            }();

            NRulesDummyContext::TContext context(answer);

            runner.Run(context.AsPtr(), YABACK_BAD_WORDS_ON_INIT_FUNCTION);

            UNIT_ASSERT_EXCEPTION(context.GetRuleProvider().Get(YABACK_BAD_WORDS_ON_INIT_RULE), yexception);
            UNIT_ASSERT_EXCEPTION(context.GetShingler().Get(68), yexception);
        }
        {
            const NHtmlSanMisc::TAnswer answer = [](){
                TFileInput stream(SRC_("bad-words-so-response.json"));
                NJson::TJsonValue v = NJson::ReadJsonTree(&stream, true);
                v["rcpttos_userinfos"]["dpotapov@yandex-team.ru"]["uid"] = 1120000000004695;
                return NHtmlSanMisc::TAnswer::Parse(v);
            }();

            NRulesDummyContext::TContext context(answer);

            runner.Run(context.AsPtr(), YABACK_BAD_WORDS_ON_INIT_FUNCTION);

            UNIT_ASSERT_EXCEPTION(context.GetRuleProvider().Get(YABACK_BAD_WORDS_ON_INIT_RULE), yexception);
            UNIT_ASSERT_EXCEPTION(context.GetShingler().Get(68), yexception);
        }
        {
            const NHtmlSanMisc::TAnswer answer = [](){
                TFileInput stream(JoinFsPaths(ArcadiaSourceRoot(), "mail/so/daemons/so2/so2/test/resources/ru/yandex/mail/so2/calendar-so-response.json"));
                return NHtmlSanMisc::TAnswer::Parse(NJson::ReadJsonTree(&stream, true));
            }();

            NRulesDummyContext::TContext context(answer);

            runner.Run(context.AsPtr(), YABACK_BAD_WORDS_ON_INIT_FUNCTION);

            UNIT_ASSERT_EXCEPTION(context.GetRuleProvider().Get(YABACK_BAD_WORDS_ON_INIT_RULE), yexception);
            UNIT_ASSERT_EXCEPTION(context.GetShingler().Get(68), yexception);
        }
    }
    Y_UNIT_TEST(SHINGLES) {
        NLua::TRunner runner;
        runner.Load(JoinFsPaths(ArcadiaSourceRoot(), "mail/so/spamstop/rules/common/headers.lua"));
        UNIT_ASSERT(runner.FunctionExists("SHINGLES"));

        {
            const NHtmlSanMisc::TAnswer answer;
            const NJson::TJsonValue shingles = [](){
                TFileInput stream(SRC_("shingles.json"));
                return NJson::ReadJsonTree(&stream);
            }();

            NRulesDummyContext::TContext context(answer);

            runner.Run(context.AsPtr(), "SHINGLES", shingles);

            UNIT_ASSERT(context.GetRuleProvider().Get("SH_14_H_200").IsActive());
            UNIT_ASSERT(context.GetRuleProvider().Get("SH_24_H_50").IsActive());
            UNIT_ASSERT(context.GetRuleProvider().Get("SH_24_H_200").IsActive());
            UNIT_ASSERT(context.GetRuleProvider().Get("SH_24_H_500").IsActive());
        }
    }
}
