#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/common/env.h>
#include <library/cpp/testing/common/network.h>
#include <mail/so/daemons/sp-daemon/lib/sp-daemon-server.h>
#include <mail/so/spamstop/sp/rulesholder.h>
#include <mail/so/libs/lua_rules/dummy_context.h>
#include "sp-daemon-test-config.h"

#include <util/system/env.h>

NCurl::TCurl CLIENT;
auto HTTP_PORT = NTesting::GetFreePort();

TString ReadFile(const TFsPath& path) {
    TIFStream fileStream(path);
    return fileStream.ReadAll();
}

TSoConfig ReadAndPatchConfig() {
    TString origin = ReadFile(JoinFsPaths(ArcadiaSourceRoot(), "mail/so/daemons/sp-daemon/scripts/templates/spam-in-prod.ini.template"));

    SetEnv("TVM_SECRET", "SECRET");

    SubstGlobal(origin, "$(STATE_DIR)", GetWorkPath());
    SubstGlobal(origin, "$(SOLVER_THREADS_COUNT)", "1");
    SubstGlobal(origin, "$(SP_LOGGER_PORT)", "123");
    SubstGlobal(origin, "$(RULES_CHECKED_DIR)", JoinFsPaths(ArcadiaSourceRoot(), "mail/so/spamstop/rules"));
    SubstGlobal(origin, "$(ALL_CAS_PATH)", JoinFsPaths(ArcadiaSourceRoot(), "mail/tools/nanny_helpers/nanny_service_base/files/allCAs.pem"));
    SubstGlobal(origin, "$(LOG_LEVEL)", "DEBUG");
    SubstGlobal(origin, "$(HTTP_PORT)", ToString(HTTP_PORT));
    SubstGlobal(origin, "$(THREADS_COUNT)", "1");

    SubstGlobal(origin, "$(MAILLOG_PATH)", JoinFsPaths(GetOutputPath(), "mail.log"));
    SubstGlobal(origin, "$(DELIVERYLOG_PATH)", JoinFsPaths(GetOutputPath(), "dlv.log"));
    SubstGlobal(origin, "$(SHORTLOG_PATH)", JoinFsPaths(GetOutputPath(), "short.log"));
    SubstGlobal(origin, "$(MLLOG_PATH)", JoinFsPaths(GetOutputPath(), "ml.log"));
    SubstGlobal(origin, "$(KASPERSKYLOG_PATH)", JoinFsPaths(GetOutputPath(), "kaspersky.log"));
    SubstGlobal(origin, "$(ACCESSLOG_PATH)", JoinFsPaths(GetOutputPath(), "access.log"));
    SubstGlobal(origin, "$(ERRORLOG_PATH)", JoinFsPaths(GetOutputPath(), "error.log"));

    SubstGlobal(origin, "$(TVM_CLIENT_ID)", "2010396");
    SubstGlobal(origin, "$(SENDERS_TVM_CLIENT_ID)", "1");

    SubstGlobal(origin, "$(TEXT_TO_VEC_DSSM)", "MailEmbedDssm.dssm");
    SubstGlobal(origin, "MatrixnetLibDir = ./ml_models/files/", "");
    SubstGlobal(origin, "MatrixnetConfigPath = ./ml_models/files/models_info.json", "");

    SubstGlobal(origin, "$(DOMEN_FACTORS_TRIE)", "trie");
    SubstGlobal(origin, "$(RULES_DICT_PATH)", "rules_dict_in.txt");

    SubstGlobal(origin, "$(RECORDER_DICT_PATH)", "recorder_dict/dict.dict");

    SubstGlobal(origin, "$(TRUSTED_ZONES_PATH)", JoinFsPaths(ArcadiaSourceRoot(), "mail/so/spamstop/rules/ut/trusted_zone"));
    SubstGlobal(origin, "$(INTRANET_ZONES_PATH)", JoinFsPaths(ArcadiaSourceRoot(), "mail/so/spamstop/rules/ut/intranet_zone"));
    SubstGlobal(origin, "$(LOCAL_ZONES_PATH)", JoinFsPaths(ArcadiaSourceRoot(), "mail/so/spamstop/rules/ut/local_zone"));

    SubstGlobal(origin, "$(SENDERS_HOST)", "http://sosearch-proxy.mail.yandex.net");
    SubstGlobal(origin, "$(SENDERS_PORT)", "80");

    SubstGlobal(origin, "$(BLACKBOX_TVM_CLIENT_ID)", "222");
    SubstGlobal(origin, "$(BLACKBOX_HOST)", "http://blackbox-mail.yandex.net");
    SubstGlobal(origin, "$(CORP_BLACKBOX_TVM_CLIENT_ID)", "239");
    SubstGlobal(origin, "$(CORP_BLACKBOX_HOST)", "http://blackbox.yandex-team.ru");

    TStringInput stringStream(origin);

    TSoConfig soConfig(NConfig::TConfig::FromIni(stringStream));
    soConfig.TvmConfig = Nothing();
    return soConfig;
}

void SendStop() {
    NCurl::TSimpleArtifacts art;

    CLIENT.Setup(std::move(
        NCurl::TRequestContext()
            .SetPort(HTTP_PORT)
            .SetHost("localhost/stop")));
    if(auto err = CLIENT.Perform(art)) {
        ythrow yexception() << err;
    }
}

TString SendSo2Request(TString data) {
    NCurl::TSimpleArtifacts art;

    CLIENT.Setup(std::move(
        NCurl::TRequestContext()
            .SetPort(HTTP_PORT)
            .SetHost("localhost/v3/antispam?session_id=1&format=protobuf-json")
            .SetPostData(std::move(data))));
    if(auto err = CLIENT.Perform(art)) {
        ythrow yexception() << err;
    }

    if(art.code != HTTP_OK) {
        ythrow yexception() << art.body.Str();
    }

    return FormatJson(art.body.Str());
}

Y_UNIT_TEST_SUITE(TestServer) {
    Y_UNIT_TEST(IN) {

        const TSoConfig config = ReadAndPatchConfig();

        TSpDaemonServer spDaemonServer(config);

        spDaemonServer.Start();

        Y_DEFER{
            SendStop();
            spDaemonServer.Wait();
        };

        const TSpDaemonTestConfig samplesConfig = [](){
            TFileInput configFile(JoinFsPaths(ArcadiaSourceRoot(), "mail/so/spamstop/rules/ut/samples-conf.json"));
            return TSpDaemonTestConfig(NConfig::TConfig::FromJson(configFile));
        }();

        for(const TTestSampleConfig& sampleConfig: samplesConfig.GetSamples()) {
            const TString response = SendSo2Request(sampleConfig.GetPathToSo2Request().ReadJson());
            UNIT_ASSERT_VALUES_EQUAL(sampleConfig.GetPathToSo2Response().ReadJson(), response);
        }
    }
}
