#pragma once

#include <utility>
#include <vector>
#include <string>
#include <util/system/defaults.h>
#include <util/generic/string.h>
#include <library/cpp/logger/log.h>

namespace NArchive {
    enum EArchParseResult {
        ArchParseOk = 0x0,
        ArchParseNoEof = 0x1,
        ArchParseNameDecodeError = 0x2,
        ArchPasswordProtected = 0x4,
        ArchInitFail = 0x8,
    };
}
struct TArciveItem {
    TArciveItem() = default;
    TArciveItem(TString s_file_name, ui64 file_size) noexcept
        : name(std::move(s_file_name))
        , size(file_size)
    {
    }
    TString name;
    //ui64 crc;
    ui64 size{};
};

class TRecognizer;
ui64 GetArchiveContents(const TLog& logger, const char* data, size_t data_size, const char* suffix, const char* qidLabel, void* gsp, std::vector<TArciveItem>* result, TRecognizer* recoder);
const char* is_archive(const TString& name);
bool is_unsupported_archive(const TString& name);
bool is_executable(const TString& name);
bool is_image(const TString& name);
TString normalize_name(const TString& file_name, bool full_path = false, size_t max_name_len = 128);
