#include <array>
#include <string.h>

#include <mail/so/spamstop/tools/so-common/sputil.h>

#include "sptypes.h"
#include "arform.h"
//#include "sperror.h"
#include "context_symbols.h"


static const auto SYM_TABLE = []{
    std::array<char, 256> table{};

    table[0x09] = SP_SPACE;
    table[0x0A] = SP_SPACE;
    table[0x0D] = SP_SPACE;
    table[0x20] = SP_SPACE;

    table[(ui8)(AR_SIGN_PLUS)] = SP_PLUS;
    table[(ui8)(AR_SIGN_MINUS)] = SP_MINUS;

    table[(ui8)(AR_SIGN_GREAT)] = SP_GREAT;

    table[(ui8)(AR_SIGN_LESS)] = SP_LESS;

    return table;
}();

ecRet TArForm::Parse(const char* expr, int len, TAr_Result* pres) {
    int i, ibeg;
    bool fsign = false;
    ui8* uexpr = (ui8*)expr;

    pres->cWords = 0;
    m_szError[0] = 0;
    pres->rgSigns[0] = AR_SIGN_PLUS;

    for (i = 0; i < len; i++) {
        switch (SYM_TABLE[uexpr[i]]) {
            case SP_NULL:
                ibeg = i;
                while (SYM_TABLE[uexpr[i]] == SP_NULL && i < len)
                    i++;
                if (pres->cWords >= AR_MAX_WORDS - 1) {
                    sprintf(m_szError, "Too much words (max = %d) in expression", AR_MAX_WORDS - 1);
                    return ecData;
                }
                if (pres->cWords && !fsign) {
                    sprintf(m_szError, "Sign is absent: %s ", (expr + ibeg));
                    return ecData;
                }
                pres->rgpWords[pres->cWords] = expr + ibeg;
                pres->rgWordsLen[pres->cWords++] = i - ibeg;
                i--;
                fsign = false;
                break;

            case SP_SPACE:
                break;

            case SP_PLUS:
            case SP_MINUS:
                if (fsign) {
                    sprintf(m_szError, "Repeated sign  in expression");
                    return ecData;
                }
                fsign = true;
                pres->rgSigns[pres->cWords] = expr[i];
                break;

            case SP_GREAT:
            case SP_LESS:
                if (fsign) {
                    sprintf(m_szError, "Sign place error");
                    return ecData;
                }
                if (pres->cWords < 2) {
                    sprintf(m_szError, "Format expression error");
                    return ecData;
                }
                pres->comp = expr[i++];
                while (SYM_TABLE[uexpr[i]] == SP_SPACE && i < len)
                    i++;
                if (i == len || !isdigit(expr[i])) {
                    sprintf(m_szError, "Right part of expression not defined");
                    return ecData;
                }
                pres->value = atoi(expr + i);
                return ecOK;
            default:
                break;
        }
    }

    return ecOK;
}
