#include <array>
#include <string.h>
#include "sptypes.h"
#include "bform.h"
//#include "sperror.h"
#include <util/generic/bt_exception.h>
#include "context_symbols.h"

#define BF_WORD_VALUE(val, ind) ((((val) >> (ind)) & 1) == 1)

static const auto SYM_TABLE = [](){
    std::array<char, 256> table{};

    table[0x09] = SP_SPACE;
    table[0x0A] = SP_SPACE;
    table[0x0D] = SP_SPACE;
    table[0x20] = SP_SPACE;

    table[(ui8)('(')] = SP_OPEN_BRACKET;
    table[(ui8)(')')] = SP_CLOSE_BRACKET;

    table[(ui8)('&')] = SP_AMPERSAND;

    table[(ui8)('|')] = SP_OR;

    table[(ui8)('^')] = SP_NEGATE;
    table[(ui8)('!')] = SP_NEGATE;

    return table;
}();
#define IS_NEGATE(sym) (SYM_TABLE[(ui8)(sym)] == SP_NEGATE)


void TBForm::Request(const char* bexpr, int len, TBF_Result* presult) {
    presult->cWords = 0;
    m_pres = presult;
    memset(presult->rgResult, 0, sizeof(presult->rgResult));

    MakeNf(bexpr, len);

    TestBrackets();

    for (int val = 0; val < (1 << presult->cWords); val++)
        if (ComputeResult(0, val))
            SetResult(val);
}

void TBForm::MakeNf(const char* frm, int len_frm) {
    int i, ibeg;
    int opbr = 1, clbr = 1, numw = 0;
    ui8* ufrm = (ui8*)frm;

    m_nflen = 0;

    for (i = 0; i < len_frm && m_nflen < BF_MAX_NF - 2; i++) {
        switch (SYM_TABLE[ufrm[i]]) {
            case SP_NULL:
                ibeg = i;
                m_nf[m_nflen++] = 'w';
                m_nf[m_nflen++] = numw++;
                while (SYM_TABLE[ufrm[i]] == SP_NULL && i < len_frm)
                    i++;
                if (m_pres->cWords >= BF_MAX_WORDS) {
                    ythrow TWithBackTrace<yexception>() << "Too much words (max = " << BF_MAX_WORDS << ") in expression";
                }
                m_pres->rgpWords[m_pres->cWords] = frm + ibeg;
                m_pres->rgWordsLen[m_pres->cWords++] = i - ibeg;
                i--;
                break;

            case SP_SPACE:
                break;

            case SP_OPEN_BRACKET:
                m_nf[m_nflen++] = frm[i];
                m_nf[m_nflen++] = opbr++;
                break;

            case SP_CLOSE_BRACKET:
                m_nf[m_nflen++] = frm[i];
                if (++clbr > opbr) {
                    ythrow TWithBackTrace<yexception>() << "Brackets error";
                }
                break;

            case SP_AMPERSAND:
                m_nf[m_nflen++] = frm[i];
                if (SYM_TABLE[ufrm[i + 1]] == SP_AMPERSAND) // & or && may be
                    ++i;
                break;
            case SP_OR:
                m_nf[m_nflen++] = frm[i];
                if (SYM_TABLE[ufrm[i + 1]] == SP_OR) // | or || may be
                    ++i;
                break;
            default:
                m_nf[m_nflen++] = frm[i];
        }
    }

    if (i < len_frm) {
        ythrow TWithBackTrace<yexception>() << "expression, perhaps outsize";
    }

    if (opbr != clbr) // open brackets count != closed brackets count
    {
        ythrow TWithBackTrace<yexception>() << "Brackets error";
    }

    m_cBrac = opbr;
}

void TBForm::TestBrackets() {
    int i, j, count, n, jw, b, e;
    char prim[BF_MAX_NF];

    m_brac[0].beg = 0; // Body "external bracket"
    m_brac[0].len = m_nflen;

    for (i = 0; i < m_nflen; i++) // defined bodies of brackets
    {
        if (m_nf[i] == 'w')
            i++;
        if (m_nf[i] == '(') {
            n = m_nf[++i];
            for (j = ++i, count = 1; j < m_nflen; j++) {
                if (m_nf[j] == 'w') {
                    j++;
                    continue;
                }
                if (m_nf[j] == '(') {
                    count++;
                    j++;
                    continue;
                }
                if (m_nf[j] == ')') {
                    count--;
                    if (count == 0)
                        break;
                    continue;
                }
            }
            m_brac[n].beg = i;
            m_brac[n].len = j - i;
            i--;
        }
    }

    for (j = 0; j < m_cBrac; j++) {
        b = m_brac[j].beg;
        e = b + m_brac[j].len;
        for (i = b, jw = 0; i < e; i++) {
            switch (m_nf[i]) {
                case '&':
                case '|':
                case '^':
                case '!':
                    prim[jw++] = m_nf[i];
                    break;

                case 'w':
                    prim[jw++] = m_nf[i++];
                    break;

                case '(':
                    prim[jw++] = 'w';
                    i += m_brac[(ui8)(m_nf[i + 1])].len + 2;
                    break;
            }
        }

        TestPrim(prim, jw);
    }
}

void TBForm::TestPrim(const char* prim, int len) {
    int i;
    bool fword = false;
    char wp1;

    for (i = 0; i < len; i++) {
        wp1 = prim[i + 1];
        switch (prim[i]) {
            case 'w':
                fword = true;
                if (i < len - 1 && wp1 != '&' && wp1 != '|') {
                    ythrow TWithBackTrace<yexception>() << "Word must be followed by operation: " << TStringBuf(prim, len);
                }
                break;
            case '^':
            case '!':
                if (i == len - 1 || wp1 != 'w') {
                    ythrow TWithBackTrace<yexception>() << "Negation must be followed by word: " << TStringBuf(prim, len);
                }
                break;
            case '|':
            case '&':
                if (i == 0 || i == len - 1 || (!(IS_NEGATE(wp1)) && wp1 != 'w')) {
                    ythrow TWithBackTrace<yexception>() << "Operation error: " << TStringBuf(prim, len);
                }
                break;
            default:
                break;
        }
    }

    if (!fword) {
        ythrow TWithBackTrace<yexception>() << "Brackets must contain words";
    }
}

bool TBForm::ComputeResult(int ind, int value) {
    int i = 0, n;
    bool fneg = false;
    char* pnf;
    int len_nf;
    bool fres = false;

    pnf = m_nf + m_brac[ind].beg;
    len_nf = m_brac[ind].len;

    if (IS_NEGATE(*pnf)) {
        i = 1;
        fneg = true;
    }

    switch (pnf[i]) {
        case 'w':
            fres = BF_WORD_VALUE(value, pnf[i + 1]);
            i += 2;
            break;
        case '(':
            n = pnf[i + 1];
            fres = ComputeResult(n, value);
            m_brac[n].fres = fres;
            i += m_brac[n].len + 3;
            break;
        default:
            ythrow TWithBackTrace<yexception>() << "Format error: function ComputeResult";
    }

    if (fneg)
        fres = !fres;

    if (i == len_nf)
        return fres;

    for (; i < len_nf;) {
        if (pnf[i] == '|') {
            if (fres)
                return true;
        } else {
            if (!fres) {
                for (; i < len_nf && pnf[i] == '&';) {
                    ++i;
                    if (IS_NEGATE(pnf[i]))
                        i++;
                    if (pnf[i] == 'w')
                        i += 2;
                    else {
                        n = pnf[i + 1];
                        i += m_brac[n].len + 3;
                    }
                }
            }
        }
        i++;
        fneg = false;
        if (i < len_nf) {
            if (IS_NEGATE(pnf[i])) {
                i++;
                fneg = true;
            }
            switch (pnf[i]) {
                case 'w':
                    fres = BF_WORD_VALUE(value, pnf[i + 1]);
                    i += 2;
                    break;
                case '(':
                    n = pnf[i + 1];
                    fres = ComputeResult(n, value);
                    m_brac[n].fres = fres;
                    i += m_brac[n].len + 3;
                    break;
                default:
                    ythrow TWithBackTrace<yexception>() << "Format error: function ComputeResult";
            }
            if (fneg)
                fres = !fres;
        }
    }

    return fres;
}

void TBForm::SetResult(int value) {
    int ind = value >> 3;
    m_pres->rgResult[ind] |= 1 << (value & 7);
}
