#pragma once

#ifndef __BFORM_H__
#define __BFORM_H__

#define BF_MAX_WORDS 10

#if BF_MAX_WORDS > 3
#define BF_MAX_RESULTS 1 << (BF_MAX_WORDS - 3)
#else
#define BF_MAX_RESULTS 1
#endif

struct TBF_Result {
    const char* rgpWords[BF_MAX_WORDS]{};
    int rgWordsLen[BF_MAX_WORDS]{};
    int cWords{};
    ui8 rgResult[BF_MAX_RESULTS]{};
};

typedef struct _TBF_Brac {
    int beg{};
    int len{};
    bool fres{};
} TBF_Brac;


class TBForm {
private:
#define BF_MAX_NF BF_MAX_WORDS * 20
    char m_nf[BF_MAX_NF]{};
    int m_nflen{};
    TBF_Brac m_brac[BF_MAX_NF];
    int m_cBrac{};
    TBF_Result* m_pres{};

    void MakeNf(const char* frm, int len_frm);
    void TestBrackets();
    void TestPrim(const char* prim, int len);
    bool ComputeResult(int ind, int value);
    void SetResult(int value);

public:
    void Request(const char* bexpr, int len, TBF_Result* presult);
};

#endif // __BFORM_H__
