//
// Created by luckybug on 02.09.2020.
//
#include "chars.h"

namespace NUnicodeRange {
    int UnicodeBlockCodeBySymbol(wchar16 UnicodeChar) {
        if (UnicodeChar >= CONTROL_CHARACTERS && UnicodeChar < CONTROL_CHARACTERS_END)
            return CODE_CONTROL_CHARACTERS;
        if (UnicodeChar >= BASIC_LATIN && UnicodeChar < BASIC_LATIN_END)
            return CODE_BASIC_LATIN;
        if (UnicodeChar >= LATIN_EXTENDED_A && UnicodeChar < LATIN_EXTENDED_A_END)
            return CODE_LATIN_EXTENDED_A;
        if (UnicodeChar >= LATIN_EXTENDED_B && UnicodeChar < LATIN_EXTENDED_B_END)
            return CODE_LATIN_EXTENDED_B;
        if (UnicodeChar >= IPA_EXTENSIONS && UnicodeChar < IPA_EXTENSIONS_END)
            return CODE_IPA_EXTENSIONS;
        if (UnicodeChar >= COMBINING_DIACRITICAL_MARKS && UnicodeChar < COMBINING_DIACRITICAL_MARKS_END)
            return CODE_COMBINING_DIACRITICAL_MARKS;
        if (UnicodeChar >= GREEK && UnicodeChar < GREEK_END)
            return CODE_GREEK;
        if (UnicodeChar >= CYRILLIC && UnicodeChar < CYRILLIC_END)
            return CODE_CYRILLIC;
        if (UnicodeChar >= CYRILLIC_SUPPLEMENTARY && UnicodeChar < CYRILLIC_SUPPLEMENTARY_END)
            return CODE_CYRILLIC_SUPPLEMENTARY;
        if (UnicodeChar >= ARMENIAN && UnicodeChar < ARMENIAN_END)
            return CODE_ARMENIAN;
        if (UnicodeChar >= HEBREW && UnicodeChar < HEBREW_END)
            return CODE_HEBREW;
        if (UnicodeChar >= ARABIC && UnicodeChar < ARABIC_END)
            return CODE_ARABIC;
        if (UnicodeChar >= ARABIC_SUPPLEMENT && UnicodeChar < ARABIC_SUPPLEMENT_END)
            return CODE_ARABIC_SUPPLEMENT;
        if (UnicodeChar >= ARABIC_EXTENDED_A && UnicodeChar < ARABIC_EXTENDED_A_END)
            return CODE_ARABIC_EXTENDED_A;
        if (UnicodeChar >= THAI && UnicodeChar < THAI_END)
            return CODE_THAI;
        if (UnicodeChar >= LAO && UnicodeChar < LAO_END)
            return CODE_LAO;
        if (UnicodeChar >= MYANMAR && UnicodeChar < MYANMAR_END)
            return CODE_MYANMAR;
        if (UnicodeChar >= GEORGIAN && UnicodeChar < GEORGIAN_END)
            return CODE_GEORGIAN;
        if (UnicodeChar >= HANGUL_JAMO && UnicodeChar < HANGUL_JAMO_END)
            return CODE_HANGUL_JAMO;
        if (UnicodeChar >= KHMER && UnicodeChar < KHMER_END)
            return CODE_KHMER;
        if (UnicodeChar >= CJK_SYMBOLS_AND_PUNCTUATION && UnicodeChar < CJK_SYMBOLS_AND_PUNCTUATION_END)
            return CODE_CJK_SYMBOLS_AND_PUNCTUATION;
        if (UnicodeChar >= HIRAGANA && UnicodeChar < HIRAGANA_END)
            return CODE_HIRAGANA;
        if (UnicodeChar >= KATAKANA && UnicodeChar < KATAKANA_END)
            return CODE_KATAKANA;
        if (UnicodeChar >= CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A && UnicodeChar < CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A_END)
            return CODE_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A;
        if (UnicodeChar >= DEVANAGARI && UnicodeChar < DEVANAGARI_END)
            return CODE_DEVANAGARI;
        if (UnicodeChar >= CJK_UNIFIED_IDEOGRAPHS && UnicodeChar < CJK_UNIFIED_IDEOGRAPHS_END)
            return CODE_CJK_UNIFIED_IDEOGRAPHS;
        if (UnicodeChar >= HANGUL_SYLLABLES && UnicodeChar < HANGUL_SYLLABLES_END)
            return CODE_HANGUL_SYLLABLES;
        if (UnicodeChar >= PRIVATE_USE_AREA && UnicodeChar < PRIVATE_USE_AREA_END)
            return CODE_PRIVATE_USE_AREA;

        return CODE_UNKNOWN;
    }

    const char* UnicodeBlockNameByCode(int code) {
        if (code >= 0 && code <= CODE_UNKNOWN)
            return UnicodeBlockNames[code];
        return "";
    }

    bool IsRare(int code) {
        return code != CODE_CONTROL_CHARACTERS &&
               code != CODE_BASIC_LATIN &&
               code != CODE_BASIC_LATIN &&
               code != CODE_CYRILLIC;
    }
}; // namespace NUnicodeRange
