#pragma once

#include <util/system/types.h>

namespace NUnicodeRange {
    static const wchar16 CONTROL_CHARACTERS = 0x0;
    static const wchar16 CONTROL_CHARACTERS_END = 0x1F;
    static const wchar16 BASIC_LATIN = 0x20;
    static const wchar16 BASIC_LATIN_END = 0x7F;
    static const wchar16 LATIN_EXTENDED_A = 0x0100;
    static const wchar16 LATIN_EXTENDED_A_END = 0x0180;
    static const wchar16 LATIN_EXTENDED_B = 0x0180;
    static const wchar16 LATIN_EXTENDED_B_END = 0x0250;
    static const wchar16 IPA_EXTENSIONS = 0x0250;
    static const wchar16 IPA_EXTENSIONS_END = 0x02b0;
    static const wchar16 COMBINING_DIACRITICAL_MARKS = 0x0300;
    static const wchar16 COMBINING_DIACRITICAL_MARKS_END = 0x0370;
    static const wchar16 GREEK = 0x0370;
    static const wchar16 GREEK_END = 0x0400;
    static const wchar16 CYRILLIC = 0x0400;
    static const wchar16 CYRILLIC_END = 0x0500;
    static const wchar16 CYRILLIC_SUPPLEMENTARY = 0x0500;
    static const wchar16 CYRILLIC_SUPPLEMENTARY_END = 0x0530;
    static const wchar16 ARMENIAN = 0x0530;
    static const wchar16 ARMENIAN_END = 0x0590;
    static const wchar16 HEBREW = 0x0590;
    static const wchar16 HEBREW_END = 0x0600;
    static const wchar16 ARABIC = 0x0600;
    static const wchar16 ARABIC_END = 0x0700;
    static const wchar16 ARABIC_SUPPLEMENT = 0x0750;
    static const wchar16 ARABIC_SUPPLEMENT_END = 0x0780;
    static const wchar16 ARABIC_EXTENDED_A = 0x08A0;
    static const wchar16 ARABIC_EXTENDED_A_END = 0x0900;
    static const wchar16 THAI = 0x0E00;
    static const wchar16 THAI_END = 0x0E80;
    static const wchar16 LAO = 0x0E80;
    static const wchar16 LAO_END = 0x0F00;
    static const wchar16 MYANMAR = 0x1000;
    static const wchar16 MYANMAR_END = 0x10A0;
    static const wchar16 GEORGIAN = 0x10A0;
    static const wchar16 GEORGIAN_END = 0x1100;
    static const wchar16 HANGUL_JAMO = 0x1100;
    static const wchar16 HANGUL_JAMO_END = 0x1200;
    static const wchar16 KHMER = 0x1780;
    static const wchar16 KHMER_END = 0x1800;
    static const wchar16 CJK_SYMBOLS_AND_PUNCTUATION = 0x3000;
    static const wchar16 CJK_SYMBOLS_AND_PUNCTUATION_END = 0x3040;
    static const wchar16 HIRAGANA = 0x3040;
    static const wchar16 HIRAGANA_END = 0x30A0;
    static const wchar16 KATAKANA = 0x30A0;
    static const wchar16 KATAKANA_END = 0x3100;
    static const wchar16 CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A = 0x3400;
    static const wchar16 CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A_END = 0x4DC0;
    static const wchar16 CJK_UNIFIED_IDEOGRAPHS = 0x4E00;
    static const wchar16 DEVANAGARI = 0x900;
    static const wchar16 DEVANAGARI_END = 0x980;
    static const wchar16 CJK_UNIFIED_IDEOGRAPHS_END = 0xA000;
    static const wchar16 HANGUL_SYLLABLES = 0xAC00;
    static const wchar16 HANGUL_SYLLABLES_END = 0xD7B0;
    static const wchar16 PRIVATE_USE_AREA = 0xE000;
    static const wchar16 PRIVATE_USE_AREA_END = 0xF900;

    enum UnicodeBlockCodes { CODE_CONTROL_CHARACTERS,
        CODE_BASIC_LATIN,
        CODE_LATIN_EXTENDED_A,
        CODE_LATIN_EXTENDED_B,
        CODE_IPA_EXTENSIONS,
        CODE_COMBINING_DIACRITICAL_MARKS,
        CODE_GREEK,
        CODE_CYRILLIC,
        CODE_CYRILLIC_SUPPLEMENTARY,
        CODE_ARMENIAN,
        CODE_HEBREW,
        CODE_ARABIC,
        CODE_ARABIC_SUPPLEMENT,
        CODE_ARABIC_EXTENDED_A,
        CODE_THAI,
        CODE_LAO,
        CODE_MYANMAR,
        CODE_GEORGIAN,
        CODE_HANGUL_JAMO,
        CODE_KHMER,
        CODE_CJK_SYMBOLS_AND_PUNCTUATION,
        CODE_HIRAGANA,
        CODE_KATAKANA,
        CODE_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A,
        CODE_CJK_UNIFIED_IDEOGRAPHS,
        CODE_DEVANAGARI,
        CODE_HANGUL_SYLLABLES,
        CODE_PRIVATE_USE_AREA,
        CODE_UNKNOWN
    };

    static const char* UnicodeBlockNames[] = {"CONTROL_CHARACTERS", "BASIC_LATIN",
                                              "LATIN_EXTENDED_A", "LATIN_EXTENDED_B", "IPA_EXTENSIONS",
                                              "COMBINING_DIACRITICAL_MARKS", "GREEK", "CYRILLIC",
                                              "CYRILLIC_SUPPLEMENTARY", "ARMENIAN", "HEBREW",
                                              "ARABIC", "ARABIC_SUPPLEMENT", "ARABIC_EXTENDED_A",
                                              "THAI", "LAO", "MYANMAR",
                                              "GEORGIAN", "HANGUL_JAMO", "KHMER",
                                              "CJK_SYMBOLS_AND_PUNCTUATION", "HIRAGANA",
                                              "KATAKANA", "CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A", "CJK_UNIFIED_IDEOGRAPHS",
                                              "DEVANAGARI", "HANGUL_SYLLABLES", "PRIVATE_USE_AREA",
                                              "UNKNOWN"};

    int UnicodeBlockCodeBySymbol(wchar16 UTFchar);
    const char* UnicodeBlockNameByCode(int code);
    bool IsRare(int code);
} // namespace NUnicodeRange
