#pragma once

#include "sptypes.h"

enum TSpSymbols {
    SP_NULL,
    SP_SPACE,
    SP_OPEN_BRACKET,
    SP_CLOSE_BRACKET,
    SP_AMPERSAND,
    SP_OR,
    SP_NEGATE,
    SP_PLUS,
    SP_MINUS,
    SP_GREAT,
    SP_LESS,
    SP_UPPER,
    SP_LOWER,
    SP_DIGIT,
    SP_QUOTE,
    SP_SIGN,
    SP_EXCLAM,
    SP_DOT,
    SP_LETTER,
    SP_DIGIT_FORGED,
    SP_SPACE_FORGED,
    SP_AT,
    SP_DOLLAR,
    SP_LAT_LETTER,
    __SP_COUNT__
};

Y_PURE_FUNCTION TSpSymbols GetHTMLSymbols(char c);
Y_PURE_FUNCTION TSpSymbols GetCaseSymbols(char c);
Y_PURE_FUNCTION TSpSymbols GetTelSymbols(char c);
Y_PURE_FUNCTION TSpSymbols GetUrlSymbols(char c);

Y_PURE_FUNCTION bool TestHtmlSymbol(char c, TSpSymbols s);
Y_PURE_FUNCTION bool TestCaseSymbol(char c, TSpSymbols s);
Y_PURE_FUNCTION bool TestTelSymbol(char c, TSpSymbols s);
Y_PURE_FUNCTION bool TestUrlSymbol(char c, TSpSymbols s);
