#include <util/generic/strbuf.h>
#include <mail/so/spamstop/tools/so-common/parsers.h>
#include <util/string/strip.h>
#include "dkim_signature.h"

TDkim TDkim::Parse(const TStringBuf src) noexcept {
    const auto b = StripString(Parseout(src, "b=", ";"));
    const auto d = StripString(Parseout(src, "d=", ";"));
    const auto s = StripString(Parseout(src, "s=", ";"));

    return {b, d, s};
}
