#pragma once

#include <util/generic/serialized_enum.h>

// Mail header fields
enum TSpFields{
    FD_UNKNOWN = 0, // unknown field
    // Incoming mail
    FD_RETURN_PATH /* "return-path" */,               // Return-path:
    FD_RECEIVED /* "received" */,                  // Received:
    FD_FROM  /* "from" */,                      // From:
    FD_FROM_NAME /* "from:name" */,                 // From:name - name part of From:
    FD_FROM_ADDR /* "from:addr" */,                 // From:addr - address part of From:
    FD_FROM_DOMAIN,               // From:addr - domain part
    FD_TO /* "to" */,                        // To:
    FD_TO_ADDR /* "to:addr" */,                   // To:addr - address part of To:
    FD_REPLY_TO /* "reply-to" */,                  // Reply-To:
    FD_REPLY_TO_ADDR /* "reply-to:addr" */,             // Reply-To:addr - address part of Reply-To:
    FD_CC /* "cc" */,                        // Cc:
    FD_CC_ADDR /* "cc:addr" */,                   // Cc:addr - address part of Cc:
    FD_SUBJECT /* "subject" */,                   // Subject:
    FD_SENDER /* "sender" */,                    // Sender:
    FD_DATE /* "date" */,                      // Date:
    FD_X_MAILER /* "x-mailer" */,                  // x-Mailer:
    FD_MIME_VERSION /* "mime-version" */,              // MIME-Version:
    FD_CONTENT_TYPE /* "content-type" */,              // Content-Type:
    FD_MESSAGE_ID /* "message-id" */,                // Message-Id:
    FD_MESSAGEID /* "messageid" */,                 // MESSAGEID:  - imitation - not real
    FD_LIST_ /* "list-" */,                     // LIST-:  - imitation - not real
    FD_LIST_POST /* "list-post" */,                 // List-Post
    FD_LIST_OWNER /* "list-owner" */,                // List-Owner
    FD_LIST_SUBSCRIBE /* "list-subscribe" */,            // List-Subscribe
    FD_X_PRIORITY /* "x-priority" */,                // x-Priority:
    FD_X_MSMAIL_PRIORITY /* "x-msmail-priority" */,         // x-Msmail-Priority:
    FD_X_MIMEOLE /* "x-mimeole" */,                 // x-MimeOLE:
    FD_X_INFO /* "x-info" */,                    // x-Info
    FD_X_ENCODING /* "x-encoding" */,                // x-Encoding
    FD_X_ESMTP /* "x-esmtp" */,                   // x-esmtp
    FD_X_LIBRARY /* "x-library" */,                 // x-Library
    FD_X_LIST_UNSUBSCRIBE /* "x-list-unsubscribe" */,        // x-List-Unsubscribe
    FD_X_MAILINGID /* "x-mailingid" */,               // x-MailingID
    FD_X_PMFLAGS /* "x-pmflags" */,                 // x-PMFLAGS
    FD_X_SERV_HOST_PRESENT /* "x-serverhost" */,       // x-ServerHost
    FD_X_STORMPOST_TO /* "x-stormpost-to" */,            // x-Stormpost-To
    FD_X_PRESENT /* "x-x" */,                 // x-x
    FD_X_FIX_PRESENT /* "x-fix" */,             // x-Fix
    FD_COMPLAIN_TO /* "complain-to" */,               // Complain-To
    FD_X_VMP_TEXT /* "x-vmp-text" */,                // x-VMP-Text
    FD_X_GCMULTI /* "x-gcmulti" */,                 // x-GCMulti
    FD_X_MIME_KEY /* "x-mime-key" */,                // x-Mime-Key
    FD_MICROSOFT /* "microsoft" */,                 // microsoft
    FD_CONTENT_DISPOSITION /* "content-disposition" */,       // Content-Disposition
    FD_CONTENT_TRANSFER_ENCODING /* "content-transfer-encoding" */, // Content-Transfer-Encoding
    FD_X_BEENTHERE /* "x-beenthere" */,               // x-BeenThere
    FD_X_PRECEDENCE_REF /* "x-precedence-ref" */,          // x-Precedence-Ref
    FD_X_ORIGINAL_TO /* "x-original-to" */,             // x-Original-To
    FD_X_FORM_ID /* "x-form-id" */,
    FD_X_SENDER_ACCOUNT /* "x-sender-account" */,

    FD_PLACEHOLDER /* "placeholder" */,

    FD_AF /* "af" */,

    FD_APPROVED_BY /* "approved-by" */,                     // Approved-By
    FD_USER_AGENT /* "user-agent" */,                      // User-Agent
    FD_X_CRON_ENV /* "x-cron-env" */,                      // x-Cron-Env
    FD_IN_REPLY_TO /* "in-reply-to" */,                     // In-Reply-To
    FD_X_AUTHENTICATION_WARNING /* "x-authentication-warning" */,        // x-Authentication-Warning
    FD_X_MAILING_LIST /* "x-mailing-list" */,                  // x-Mailing-List
    FD_X_LOOP /* "x-loop" */,                          // x-Loop
    FD_X_ACCEPT_LANGUAGE /* "x-accept-language" */,               // x-Accept-Language
    FD_RESENT_FROM /* "resent-from" */,                     // Resent-From
    FD_RESENT_SENDER /* "resent-sender" */,                   // Resent-Sender
    FD_RESENT_TO /* "resent-to" */,                       // Resent-To
    FD_RESENT_DATE /* "resent-date" */,                     // Resent-Date
    FD_ORGANIZATION /* "organization" */,                    // Organization
    FD_REFERENCES /* "references" */,                      // References
    FD_X_EGROUPS_RETURN /* "x-egroups-return" */,                // x-eGroups-Return
    FD_X_ORIGINALARRIVALTIME /* "x-originalarrivaltime" */,           // x-Originalarrivaltime
    FD_X_ORIGINATING_IP /* "x-originating-ip" */,                // x-Originating-Ip
    FD_X_SENDER_IP /* "x-sender-ip" */,                     // x-Sender-Ip
    FD_X_SENDER /* "x-sender" */,                        // x-Sender
    FD_X_MASS_MAIL /* "x-mass-mail" */,                     // x-Mass-Mail
    FD_MAILING_LIST /* "mailing-list" */,                    // Mailing-List
    FD_DELIVERED_TO /* "delivered-to" */,                    // Delivered-To
    FD_LIST_UNSUBSCRIBE /* "list-unsubscribe" */,                // List-Unsubscribe
    FD_LIST_ID /* "list-id" */,                         // List-Id
    FD_X_ANTIABUSE /* "x-antiabuse" */,                     // x-AntiAbuse
    FD_X_SCANNER /* "x-scanner" */,                       // x-Scanner
    FD_PRECEDENCE /* "precedence" */,                      // Precedence
    FD_X_MAILSCANNER /* "x-mailscanner" */,                   // x-MailScanner
    FD_AUTO_SUBMITTED /* "auto-submitted" */,                  // Auto-Submitted
    FD_X_RESENTFROM /* "x-resentfrom" */,                    // x-ResentFrom
    FD_X_AUTOGENERATED /* "x-autogenerated" */,                 // x-Autogenerated
    FD_X_SPAM /* "x-spam" */,                          // x-Spam
    FD_X_KASPERSKY_ANTIVIRUS /* "x-kaspersky-antivirus" */,           // x-Kaspersky-Antivirus
    FD_X_GMX_ANTIVIRUS /* "x-gmx-antivirus" */,                 // x-GMX-Antivirus
    FD_X_ANTIVIRUS /* "x-antivirus" */,                     // x-Antivirus
    FD_X_VIRUS_SCANNED /* "x-virus-scanned" */,                 // x-Virus-Scanned
    FD_X_CS_IP /* "x-cs-ip" */,                         // x-CS-IP
    FD_X_IP /* "x-ip" */,                            // x-IP
    FD_RECEIVED_SPF /* "received-spf" */,                    // Received-SPF
    FD_AUTHENTICATION_RESULTS /* "authentication-results" */,          // Authentication-Results
    FD_X_YANDEX_AUTHENTICATION_RESULTS /* "x-yandex-authentication-results" */, // x-yandex-authentication-results
    FD_X_DMARC /* "x-dmarc" */,                         // X_Dmarc
    FD_X_MAILRU_TYPE /* "x-mailru-msgtype" */,                   // Mairu Type

    FD_DKIM_SIGNATURE /* "dkim-signature" */,
    FD_DKIM_STATS /* "dkim_stats" */,

    FD_X_YANDEX_TIMEMARK /* "x-yandex-timemark" */,
    FD_X_YANDEX_TRACKER_SOURCE /* "x-yandex-tracker-source" */,
    FD_X_YANDEX_TRACKER /* "x-yandex-tracker" */,

    FD_X_YANDEX_TRACKER_MAIL_TYPE /* "x-yandex-tracker-mail-type" */,
    FD_X_YANDEX_TRACKER_TRANSPORT /* "x-yandex-tracker-transport" */,
    FD_X_YANDEX_TRACKER_ENV /* "x-yandex-tracker-env" */,

    FD_SUBJECT_REPLACEMETS /* "subject_replacements" */,
    FD_BODY_REPLACEMETS /* "body_replacements" */,

    FD_FULL_BODY /* "fullbody" */,
    FD_FULL_SUBJECT /* "fullsubject" */,
    FD_FULL_HTML /* "fullhtml" */,
    FD_FULL_FROM /* "fullfrom" */,
    FD_FULL_FROM_NAME /* "fullfromname" */,
    FD_FULL_FROM_ADDR /* "fullfromaddr" */,
    FD_FULL_DEOBFUSCATED_UGC /* "deobfuscated_ugc" */,
    FD_FULL_UGC_ID /* "ugc_id" */,
    FD_FULL_DOC /* "doc" */,
    FD_HBF_PROJECT_ID /* "hbf_project_id" */,
    FD_MATCHED_TEMPLATE /* "matched_template" */,
    FD_FULL_PURE_BODY /* "full_pure_body" */,

    FD_SHINGLES_MAP /* "shingles_map" */,

    FD_VISIBLE_DSSM_DISTANCE /* "visible_dssm_distance" */,
    FD_VISIBLE_DSSM_NEIGHBOUR_LABELS /* "visible_dssm_neighbour_labels" */,
    FD_DSSM_SUBJECT_DISTANCE /* "dssm_subject_distance" */,
    FD_DSSM_SUBJECT_NEIGHBOUR_LABELS /* "dssm_subject_neighbour_labels" */,

    FD_VISIBLE_PURE_BODY_WMD_DISTANCE /* "visible_pure_body_wmd_distance" */,
    FD_VISIBLE_PURE_BODY_WMD_NEIGHBOUR_LABELS /* "visible_pure_body_wmd_neighbour_labels" */,

    FD_SUBJECT_WMD_DISTANCE /* "subject_wmd_distance" */,
    FD_SUBJECT_WMD_NEIGHBOUR_LABELS /* "subject_wmd_neighbour_labels" */,

    FD_MIN_ATTACH_NAME_WMD_DISTANCE /* "min_attach_name_wmd_distance" */,
    FD_MIN_ATTACH_NAME_WMD_NEIGHBOUR_LABELS /* "min_attach_name_wmd_neighbour_labels" */,

    FD_WEIGHTS_USER /* "weights_user" */,

    //first Received meta fields
    FD_REC_HELO /* "rec-helo" */,
    FD_REC_IP /* "rec-ip" */,
    FD_REC_RDNS /* "rec-rdns" */,
    FD_REC_HELO_NEXT /* "rec-helo-next" */,
    FD_REC_IP_NEXT /* "rec-ip-next" */,
    FD_REC_RDNS_NEXT /* "rec-rdns-next" */,

    //delivery source
    FD_DLV_SRC /* "dlv-src" */,

    //tags fields
    FD_TAG_META /* "tag_meta" */, // Tag_Meta

    FD_BODY_TEXT /* "bodytext" */,     // Text of message body
    FD_RAWBODY_TEXT /* "rawbodytext" */,  // Text of message body with html
    FD_BODY_EOL_TEXT /* "eolbodytext" */, // Text of message body with eol
    FD_BODY_TAGS /* "bodytags" */,     // Tags

    FD_BODY_CONTENT_TYPE /* "body-content-type" */,
    FD_BODY_CONTENT_DISPOSITION /* "body-content-disposition" */,
    FD_BODY_ATTACHMENT_NAME /* "body-attachment-name" */,
    FD_BODY_CONTENT_CHARSET /* "body-content-charset" */,
    FD_BODY_CONTENT_TRANSFER_ENCODING /* "body-content-transfer-encoding" */,
    FD_BODY_CONTENT_TYPE_RAW /* "body-content-type-raw" */,

    FD_URL /* "url" */,            // url
    FD_URL_HTTP /* "url_http" */,       // url without https?\:\/\/
    FD_URL_HTTP_PARAM /* "url_http_param" */, // url_http_param
    FD_URL_MAILTO /* "url_mailto" */,     // url without mailto:
    FD_URL_FILE_NAME /* "url_filename" */,  // url file name
    FD_URL_PATH /* "url_path" */,       // url full file name
    FD_URL_HOST /* "url_host" */,       // url host

    FD_YADISK_FILE /* "disk_file" */, // yadisk filename
    FD_UAAS_IDS /* "uaas" */,    // uaas ids

    FD_FIELD_CODING /* "field_coding" */, // coding name

    // smtp fieldss
    FD_X_BORNDATE /* "x-borndate" */,            // x-BornDate
    FD_RCPT_BORN_DATE /* "rcpt_born_date" */,
    FD_X_MSGDAYCOUNT /* "x-msgdaycount" */,         // x-MsgDayCount
    FD_X_YANDEX_KARMA /* "x-yandex-karma" */,        // x-Yandex-Karma
    FD_X_YANDEX_KARMA_STATUS /* "x-yandex-karma-status" */, // x-Yandex-Karma-Status
    FD_X_ORIGINAL_SIZE /* "x-original-size" */,       // x-Original-Size
    FD_X_YANDEX_FRONT /* "x-yandex-front" */,        // x-Yandex-Front
    FD_X_YANDEX_CAPTCHA /* "x-yandex-captcha-entered" */,      // x-Yandex-Captcha-Entered

    FD_RCP_TO /* "envlp-rcp-to" */,               // Envlp-Rcp-To
    FD_MAIL_FROM /* "envlp-mail-from" */,            // Envlp-Mail-From
    FD_BODY_TEXT_100 /* "bodytext100" */,        // Text of message body - first 100 byte
    FD_RAWBODY_TEXT_100 /* "rawbodytext100" */,     // Text of message body with html - first 100 byte
    FD_BODY_TEXT_200 /* "bodytext200" */,        // Text of message body - first 500 byte
    FD_RAWBODY_TEXT_200 /* "rawbodytext200" */,     // Text of message body with html - first 500 byte
    FD_BODY_TEXT_500 /* "bodytext500" */,        // Text of message body - first 500 byte
    FD_RAWBODY_TEXT_500 /* "rawbodytext500" */,     // Text of message body with html - first 500 byte
    FD_BODY_TEXT_200_END /* "bodytext200end" */,    // Text of message body - last 200 byte
    FD_RAWBODY_TEXT_200_END /* "rawbodytext200end" */, // Text of message body with html - last 200 byte
    FD_BODY_TEXT_500_END /* "bodytext500end" */,    // Text of message body - last 500 byte
    FD_RAWBODY_TEXT_500_END /* "rawbodytext500end" */, // Text of message body with html - last 500 byte

    FD_RAWSUBJECT /* "rawsubject" */,           // RawSubject - subject as is
    FD_X_YANDEX_QUEUEID /* "x-yandex-queueid" */,     // base 64 decoded Queue id and mxfront
    FD_X_YAMAIL_AUTO_REPLY /* "x-yamail-auto-reply" */,  // x-yamail-auto-reply
    FD_X_SKIPPED_RECEIVED /* "x-skipped-received" */,   // x-Skipped-received
    FD_X_SKIPPED_SPF /* "x-skipped-spf" */,        // x-Skipped-SPF
    FD_X_SKIPPED_SO_FORWARD /* "x-skipped-so-forward" */, // x-Skipped-SO-Forward
    FD_X_YANDEX_GREYLISTING /* "x-yandex-greylisting" */, // x-Yandex-Greylisting
    FD_X_YANDEX_SO_GREYLISTING /* "x-yandex-so-greylisting" */,
    FD_X_YANDEX_SUID /* "x-yandex-suid" */,        // x-Yandex-Suid
    FD_IY_GEOZONE /* "iy-geozone" */,           // IY-Geozone
    FD_IY_FIRSTGEOZONE /* "iy-firstgeozone" */,      // IY-FirstGeozone
    FD_IY_LANGUAGE /* "iy-language" */,          // IY-LANGUAGE
    FD_IY_LOGTEMP /* "iy-logtemp" */,           // IY-LOGTEMP
    FD_IY_PDDADMIN /* "iy-pddadmin" */,          // pdd admin
    FD_IY_PDDIP /* "iy-pddip" */,             // pdd ip
    FD_IY_PDDADMKARMA /* "iy-pddadmkarma" */,       // pdd admin karma
    FD_IY_AS /* "iy-as" */,                // Autonome System geozone
    FD_IY_TOR /* "iy-tor" */,               // TOR geozone
    FD_IY_SPLIT_ID /* "iy-split-id" */,          // unique ID field for SO splitter
    FD_IY_DAYS_SINCE_RCVD /* "iy-receiveddate" */,   // days since msg received, rcvd date got from yandex-hint

    FD_X_YANDEX_FORWARD /* "x-yandex-forward" */,
    FD_X_YANDEX_FILTER /* "x-yandex-filter" */,
    FD_X_YANDEX_SPAM /* "x-yandex-spam" */,
    FD_X_YANDEX_FOLDERNAME /* "x-yandex-foldername" */, // x-Yandex-Foldername
    FD_X_YANDEX_RPOP_FOLDER /* "x-yandex-rpop-foldername" */,
    FD_X_YANDEX_RPOP_INFO /* "x-yandex-rpop-info" */,
    FD_X_YANDEX_POP_SERVER /* "x-yandex-pop-server" */,
    FD_X_YANDEX_SOURCE /* "x-yandex-source" */,

    FD_UTF8_BODY_TEXT /* "bodytextutf8" */,    // Text of message body in utf8
    FD_UTF8_RAWBODY_TEXT /* "rawbodytextutf8" */, // Text of message body in utf8 with html

    FD_ARCH_ATTACH_FILE /* "arch-attachment-name" */, // Archive contents file names

    FD_GEO_LANG /* "rcptgeo-language" */, // geozone + body language

    FD_ABOOK_RESPONSE /* "abook-response" */, // abook answer
    FD_X_YANDEX_EXPFLAGS /* "uaas_flags" */,

    FD_X_YANDEX_SO_FRONT /* "x-yandex-so-front" */,

    FD_LSA_RESPONSE /* "lsa_response" */,

    FD_CURRENT_TIME /* "current_time" */,

    // Outgoing mail
    FD_X_ASK_AUTH /* "x-ask-auth" */, // X-ASK-Auth
    FD_X_HOTPOP /* "x-hotpop" */, // X-HotPOP
    FD_NEWSGROUPS /* "newsgroups" */, // Newsgroups
    FD_X_YANDEX_CLIENT /* "x-yandex-client" */, // X-Yandex-Client
    FD_X_BOUNCE_TRACKING_INFO /* "x-bounce-tracking-info" */, // X-Bounce-Tracking-Info
    FD_X_AOL_IP /* "x-aol-ip" */, // "X-AOL-IP"
    FD_X_YANDEX_COUNTRY /* "x-yandex-country" */, // X-Yandex-Country
    FD_X_LIST_AGENT /* "x-list-agent" */, // X-List-Agent

    // Corp mail
    FD_LIST_ARCHIVE /* "list-archive" */, // List-Archive
    FD_X_LISTSERVER /* "x-listserver" */, // X-ListServer
    FD_X_MAILLIST_ID /* "x-maillist-id" */, // X-MailList-ID
    FD_REPLYTO /* "replyto" */, // ReplyTo
    FD_X_FACEBOOK_NOTIFY /* "x-facebook-notify" */, //  X-Facebook-Notify
    FD_JRBL /* "jrbl" */,

    FD_SENDERS_VALUE /* "senders_value" */,

    /////// headers
    FD_HEADERS /* "headers" */,

    // Incoming mail
    FD_bcc /* "bcc" */,
    FD_content_language /* "content-language" */,
    FD_resent_message_id /* "resent-message-id" */,
    FD_x_rav_antivirus /* "x-rav-antivirus" */,
    FD_x_virus_status /* "x-virus-status" */,
    FD_x_autoreply /* "x-autoreply" */,
    FD_x_mirrored_by /* "x-mirrored-by" */,
    FD_x_original_from /* "x-original-from" */,
    FD_x_autorespond /* "x-autorespond" */,
    FD_x_autoresponder /* "x-autoresponder" */,
    FD_x_originating_email /* "x-originating-email" */,
    FD_x_spam_flag /* "x-spam-flag" */,
    FD_x_spam_status /* "x-spam-status" */,
    FD_x_spamtest_status /* "x-spamtest-status" */,
    FD_x_dspam_result /* "x-dspam-result:" */,
    FD_x_hscg_spam_alert /* "x-hscg-spam-alert" */,
    FD_x_klms_antispam_status /* "x-klms-antispam-status" */,
    FD_x_rspam_status /* "x-rspam-status" */,
    FD_x_yahoo_forwarded /* "x-yahoo-forwarded" */,
    FD_x_forwarded_to /* "x-forwarded-to" */,
    FD_x_qip_forward /* "x-qip-forward" */,
    FD_x_php_script /* "x-php-script" */,
    FD_x_php_originating_script /* "x-php-originating-script" */,
    FD_x_yandex_queue_id /* "x-yandex-queue-id" */,
    FD_x_riferimento_message_id /* "x-riferimento-message-id" */,
    FD_x_original_message_id /* "x-original-message-id" */,
    FD_x_notification_id /* "x-notification-id" */,
    FD_x_ms_has_attach /* "x-ms-has-attach" */,
    FD_x_postmaster_msgtype /* "x-postmaster-msgtype" */,
    FD_x_yandex_livemail /* "x-yandex-livemail" */,
    FD_x_malier /* "x-malier" */,
    FD_content_id /* "content-id" */,
    FD_x_yahoo_newman_property /* "x-yahoo-newman-property" */,
    FD_x_notification_type /* "x-notification-type" */,
    FD_x_redmine_project /* "x-redmine-project" */,
    FD_x_redmine_site /* "x-redmine-site" */,
    FD_x_startrek /* "x-startrek" */,
    FD_x_jira_fingerprint /* "x-jira-fingerprint" */,
    FD_x_yandex_rpop_id /* "x-yandex-rpop-id" */,
    FD_x_yandex_local /* "x-yandex-local" */,
    FD_x_so_form_spam /* "x-so-form-spam" */,
    FD_original_message_id /* "original-message-id" */,
    FD_thread_topic /* "thread-topic" */,
    FD_thread_index /* "thread-index" */,
    FD_shvalue_1 /* "shvalue_1" */,
    FD_shvalue_2 /* "shvalue_2" */,
    FD_shvalue_8 /* "shvalue_8" */,
    FD_shvalue_42 /* "shvalue_42" */,
    FD_message_id /* "message_id" */,
    FD_preamble /* "preamble" */,
    FD_epilogue /* "epilogue" */,
    FD_x_spam_yversion /* "x-spam-yversion" */,
    FD_x_yaru_notification_type /* "x-yaru-notification-type" */,
    FD_x_yandex_mailish /* "x-yandex-mailish" */,
    FD_x_mras /* "x-mras" */,
    FD_x_mru_badrcptscount /* "x-mru-badrcptscount" */,
    FD_x_virus_found /* "x-virus-found" */,
    FD_shvalue_27 /* "shvalue_27" */,
    FD_x_listmember /* "x-listmember" */,
    FD_X_YANDEX_CF_RECEIPT /* "x-yandex-cf-receipt" */,
    FD_RECEIPT_VALUE /* "receipt-value" */,
    FD_list_help /* "list-help" */,

    // Outgoing mail
    FD_shvalue_13 /* "shvalue_13" */,

    // CheckForm
    FD_so_service /* "so_service" */,
    FD_so_comment /* "so_comment" */,
    FD_so_login /* "so_login" */,
    FD_form_id /* "form_id" */,
    FD_xmpp_server_name /* "xmpp_server_name" */,
    FD__all_ /* "_all_" */,
    FD_embedded_url /* "embedded_url" */,
    FD_so_subject /* "so_subject" */,
    FD_so_recipient /* "so_recipient" */,
    FD_so_q1 /* "so_q1" */,
    FD_so_nick /* "so_nick" */,
    FD_so_name /* "so_name" */,
    FD_so_q1text /* "so_q1text" */,
    FD_so_q2text /* "so_q2text" */,
    FD_so_q3text /* "so_q3text" */,
    FD_so_q4text /* "so_q4text" */,
    FD_so_q5text /* "so_q5text" */,
    FD_so_q6text /* "so_q6text" */,
    FD_so_q7text /* "so_q7text" */,
    FD_so_q8text /* "so_q8text" */,
    FD_so_q9text /* "so_q9text" */,
    FD_so_q10text /* "so_q10text" */,
    FD_so_q11text /* "so_q11text" */,
    FD_so_q12text /* "so_q12text" */,
    FB_so_q1 /* "so_q1" */,
    FB_so_q2 /* "so_q2" */,
    FB_so_q3 /* "so_q3" */,
    FB_so_q4 /* "so_q4" */,
    FB_so_q5 /* "so_q5" */,
    FB_so_q6 /* "so_q6" */,
    FB_so_q7 /* "so_q7" */,
    FB_so_q8 /* "so_q8" */,
    FB_so_q9 /* "so_q9" */,
    FB_so_q10 /* "so_q10" */,
    FB_so_q11 /* "so_q11" */,
    FB_so_q12 /* "so_q12" */,
    FB_so_q13 /* "so_q13" */,
    FB_so_q14 /* "so_q14" */,
    FB_so_q15 /* "so_q15" */,
    FB_so_q16 /* "so_q16" */,
    FB_so_q1_1 /* "so_q1_1" */,
    FB_so_q2_1 /* "so_q2_1" */,
    FB_so_q3_1 /* "so_q3_1" */,
    FB_so_q4_1 /* "so_q4_1" */,
    FB_so_q5_1 /* "so_q5_1" */,
    FB_so_q6_1 /* "so_q6_1" */,
    FB_so_q7_1 /* "so_q7_1" */,
    FB_so_q8_1 /* "so_q8_1" */,
    FB_so_q9_1 /* "so_q9_1" */,
    FB_so_q10_1 /* "so_q10_1" */,
    FB_so_q11_1 /* "so_q11_1" */,
    FB_so_q12_1 /* "so_q12_1" */,
    FB_so_q13_1 /* "so_q13_1" */,
    FB_so_q14_1 /* "so_q14_1" */,
    FB_so_q15_1 /* "so_q15_1" */,
    FB_so_q16_1 /* "so_q16_1" */,
    FB_geos /* "geos" */,
    FB_so_ip /* "so_ip" */,
    FB_office_admin_unix_xml /* "office_admin_unix.xml" */,
    FB_so_FIO /* "so_fio" */,
    FB_so_email /* "so_email" */,
    FB_so_phone /* "so_phone" */,
    FB_so_id /* "so_id" */,
    FB_so_realpath /* "so_realpath" */,
    FB_so_email2 /* "so_email2" */,
    FB_so_MK /* "so_mk" */,
    FB_so_form_name /* "so_form_name" */,
    FB_so_karma /* "so_karma" */,
    FB_so_karmastatus /* "so_karmastatus" */,
    FB_so_custom_user_nickname /* "so_custom_user_nickname" */,
    FB_so_custom_user_regemail /* "so_custom_user_regemail" */,
    FB_so_custom_from /* "so_custom_from" */,
    FB_so_custom_contacts_hours_1 /* "so_custom_contacts_hours_1" */,
    FB_so_custom_contacts_hours_24 /* "so_custom_contacts_hours_24" */,
    FB_so_custom_offer_swap /* "so_custom_offer_swap" */,
    FB_so_custom_user_hasphone /* "so_custom_user_hasphone" */,
    FB_so_custom_user_nummessages /* "so_custom_user_nummessages" */,
    FB_so_subject_template /* "subject_template" */,
    FB_so_body_template /* "body_template" */,
    FD_request_json /* "request_json" */,
    FD_so_custom_user_whitened /* "so_custom_user_whitened" */,

    // Geochats fields
    FB_form_field_value_guid /* "form_field_value_guid" */,
    FB_form_field_value_is_robot /* "form_field_value_is_robot" */,
    FB_form_field_value_chat_type /* "form_field_value_chat_type" */,
    FB_form_field_value_chat_creation_timestamp /* "form_field_value_chat_creation_timestamp" */,
    FB_form_field_value_message_timestamp /* "form_field_value_message_timestamp" */,
    FB_form_field_value_yandex_uid /* "form_field_value_yandex_uid" */,

    // CheckMessages
    FB_chatid /* "chatid" */,
    FB_chattype /* "chattype" */,
    FB_chatusers /* "chatusers" */,
    FB_messtype /* "messtype" */,
    FB_chatname /* "chatname" */,
    FB_chatdescription /* "chatdescription" */,

    // MSearch
    FB_text /* "text" */,
    FB_norm /* "norm" */,
    FB_suid /* "suid" */,
    FB_imap /* "imap" */,

    // Passport
    FB_re_v2_phone_confirmation_send_count_limit_reached /* "re_v2_phone_confirmation_send_count_limit_reached" */,
    FB_re_v2_account_country /* "re_v2_account_country" */,
    FB_re_v2_hardware_id /* "re_v2_hardware_id" */,
    FB_re_useragent /* "re_useragent" */,
    FB_re_v2_password_quality /* "re_v2_password_quality" */,
    FB_re_origin /* "re_origin" */,
    FB_re_fuid /* "re_fuid" */,
    FB_re_v2_session_age /* "re_v2_session_age" */,
    FB_pdd_geo /* "pdd_geo" */,
    FB_geos_as /* "geos_as" */,
    FB_login /* "login" */,
    FB_fname /* "fname" */,
    FB_re_v2_page_loading_info /* "re_v2_page_loading_info" */,
    FB_re_v2_is_passwords_diverged /* "re_v2_is_passwords_diverged" */,
    FB_re_v2_suggest_login_length /* "re_v2_suggest_login_length" */,
    FB_re_v2_captcha_check_count /* "re_v2_captcha_check_count" */,
    FB_re_v2_has_cookie_yp /* "re_v2_has_cookie_yp" */,
    FB_re_is_suggested_login /* "re_is_suggested_login" */,
    FB_re_consumer /* "re_consumer" */,
    FB_re_v2_has_cookie_l /* "re_v2_has_cookie_l" */,
    FB_v2_application /* "v2_application" */,
    FB_re_v2_application /* "re_v2_application" */,
    FB_re_v2_password_meshing_count /* "re_v2_password_meshing_count" */,
    FB_re_v2_phone_confirmation_confirms_count /* "re_v2_phone_confirmation_confirms_count" */,
    FB_ipaddress /* "ipaddress" */,
    FB_re_hintqid /* "re_hintqid" */,
    FB_re_v2_password_validation_count /* "re_v2_password_validation_count" */,
    FB_pdd_admin /* "pdd_admin" */,
    FB_re_v2_has_cookie_yandex_login /* "re_v2_has_cookie_yandex_login" */,
    FB_hosts /* "hosts" */,
    FB_re_v2_phone_bindings_count /* "re_v2_phone_bindings_count" */,
    FB_re_v2_has_cookie_my /* "re_v2_has_cookie_my" */,
    FB_phonenumber /* "phonenumber" */,
    FB_re_action /* "re_action" */,
    FB_re_host /* "re_host" */,
    FB_re_v2_login_validation_count /* "re_v2_login_validation_count" */,
    FB_iname /* "iname" */,
    FB_re_v2_account_timezone /* "re_v2_account_timezone" */,
    FB_pdd_ip /* "pdd_ip" */,
    FB_re_ip_from /* "re_ip_from" */,
    FB_email /* "email" */,
    FB_re_v2_has_cookie_ys /* "re_v2_has_cookie_ys" */,
    FB_re_v2_hardware_model /* "re_v2_hardware_model" */,
    FB_re_v2_account_karma /* "re_v2_account_karma" */,

    FB_mode /* "re_mode" */,
    FB_v2_accept_language /* "re_v2_accept_language" */,
    FB_v2_account_language /* "re_v2_account_language" */,
    FB_v2_old_password_quality /* "re_v2_old_password_quality" */,
    FB_v2_is_ssl_session_cookie_valid /* "re_v2_is_ssl_session_cookie_valid" */,
    FB_v2_is_ssl /* "re_v2_is_ssl" */,
    FB_v2_os_id /* "re_v2_os_id" */,
    FB_v2_language_sys /* "re_v2_language_sys" */,
    FB_v2_phonenumber_hash /* "re_v2_phonenumber_hash" */,

    FD_MAILFROM_USERINFO /* "mailfrom_userinfo" */,
    FD_RECIPIENTS_USERINFOS /* "recipients_userinfos" */,

    FD_INIT_MESSAGE /* "init_message" */,

    __FD_COUNT,
};

